/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certificate.export.key;

import com.cabaret.security.certstore.export.IKeyExporter;
import com.cabaret.security.certstore.export.StreamCertificateExporter;
import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class KeyExporter
extends StreamCertificateExporter
implements IKeyExporter {
    public static final String ARG_ALIAS = "alias";
    public static final String ARG_GENERATEPASSWORD = "generatePassword";
    public static final String ARG_STOREPASSWORD = "storePassword";
    public static final String ARG_IDPASSWORD = "idPassword";
    public static final String ARG_WRITEPASSWORDFILE = "writePasswordFile";
    public static final String ARG_PASSWORDFILELOCATOR = "passwordFileLocator";
    private static final int PASSWORD_LENGTH = 10;
    private static final Character[] PASSWORD_CHARACTERS;
    private boolean generatePassword;
    private boolean writePasswordFile;
    private ILocator passwordFileLocator;
    private String storePassword;
    private String keyPassword;
    private String alias;
    private IX509PublicKeyCertificate[] certificateChain;

    public KeyExporter(IFactory factory) {
        super(factory);
    }

    protected void basicRun() throws Exception {
        if (this.isGeneratePassword()) {
            this.generatePassword();
        }
        this.writeKeyStore();
        this.ok();
    }

    protected IX509PublicKeyCertificate[] buildCertificateChain(IX509Certificate certificate) throws IOException {
        IX509Certificate[] chain = ValidationTools.getCertificatePath((IX509Certificate)certificate);
        if (chain == null || chain.length == 0) {
            return new IX509PublicKeyCertificate[]{(IX509PublicKeyCertificate)certificate};
        }
        IX509PublicKeyCertificate[] result = new IX509PublicKeyCertificate[chain.length];
        System.arraycopy(chain, 0, result, 0, chain.length);
        return result;
    }

    protected char generateCharacter() {
        int rnd = (int)(Math.random() * (double)PASSWORD_CHARACTERS.length);
        return PASSWORD_CHARACTERS[rnd].charValue();
    }

    protected void generatePassword() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append(this.generateCharacter());
        }
        this.setKeyPassword(sb.toString());
        this.setStorePassword(sb.toString());
    }

    public String getAlias() {
        return this.alias;
    }

    public IX509PublicKeyCertificate[] getCertificateChain() throws IOException {
        return this.certificateChain;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public ILocator getPasswordFileLocator() {
        return this.passwordFileLocator;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    public boolean isGeneratePassword() {
        return this.generatePassword;
    }

    public boolean isWritePasswordFile() {
        return this.writePasswordFile;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void setCertificate(IX509Certificate certificate) {
        super.setCertificate(certificate);
        try {
            this.setCertificateChain(this.buildCertificateChain(certificate));
        }
        catch (IOException e) {
            this.setCertificateChain(new IX509PublicKeyCertificate[]{(IX509PublicKeyCertificate)certificate});
        }
    }

    public void setCertificateChain(IX509PublicKeyCertificate[] certificateChain) {
        this.certificateChain = certificateChain;
    }

    public void setGeneratePassword(boolean generatePassword) {
        this.generatePassword = generatePassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setPasswordFileLocator(ILocator passwordFileLocator) {
        this.passwordFileLocator = passwordFileLocator;
    }

    public void setStorePassword(String storePassword) {
        this.storePassword = storePassword;
    }

    public void setWritePasswordFile(boolean writePasswordFile) {
        this.writePasswordFile = writePasswordFile;
    }

    protected void writeKeyStore() throws GeneralSecurityException, IOException {
        KeyStoreFacade facade;
        ILocator locator = this.getLocator();
        boolean append = false;
        if (KeyStoreFacade.isJKS((ILocator)this.getLocator())) {
            append = this.isAppend();
        }
        if (!append && !this.isOverwrite()) {
            locator = StreamCertificateExporter.makeUnique(locator);
        }
        if ((facade = (KeyStoreFacade)KeyStoreFactory.get().create(locator)).needsKeyStorePassword() && StringTools.isEmpty((String)this.getStorePassword())) {
            this.setStorePassword(this.getKeyPassword());
        }
        if (append && locator.exists()) {
            facade.load();
        } else {
            facade.create();
        }
        KeyStore keyStore = facade.getKeyStore();
        Certificate[] certificates = CertificateTools.toJavaCerts((IX509Certificate[])this.getCertificateChain());
        int index = 1;
        for (X509Certificate x509Certificate : certificates) {
            keyStore.setCertificateEntry(String.valueOf(index++), x509Certificate);
        }
        if (facade.needsKeyPassword()) {
            keyStore.setKeyEntry(this.getAlias(), this.getPrivateKey(), this.getKeyPassword().toCharArray(), certificates);
        } else {
            keyStore.setKeyEntry(this.getAlias(), this.getPrivateKey(), null, certificates);
        }
        this.writeKeyStore(keyStore, locator);
        if (this.isWritePasswordFile()) {
            this.writePasswordFile(locator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeKeyStore(KeyStore keyStore, ILocator locator) throws GeneralSecurityException, IOException {
        OutputStream os = null;
        try {
            os = locator.getOutputStream();
            keyStore.store(os, this.getStorePassword() == null ? new char[]{} : this.getStorePassword().toCharArray());
        }
        finally {
            StreamTools.close((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePasswordFile(ILocator keyLocator) throws IOException {
        ILocator targetLocator = this.getPasswordFileLocator();
        if (targetLocator == null) {
            targetLocator = keyLocator.getParent().getChild(keyLocator.getName() + ".txt");
        }
        Writer w = targetLocator.getWriter();
        try {
            w.write("Alias: " + this.getAlias() + StringTools.LS);
            if (this.getKeyPassword() != null) {
                w.write("Key password: " + this.getKeyPassword() + StringTools.LS);
            }
            if (this.getStorePassword() != null) {
                w.write("Store password: " + this.getStorePassword() + StringTools.LS);
            }
        }
        finally {
            StreamTools.close((Closeable)w);
        }
    }

    static {
        int i;
        ArrayList<Character> characters = new ArrayList<Character>();
        for (i = 48; i <= 57; ++i) {
            characters.add(Character.valueOf((char)i));
        }
        for (i = 65; i <= 90; ++i) {
            characters.add(Character.valueOf((char)i));
        }
        for (i = 97; i <= 122; ++i) {
            characters.add(Character.valueOf((char)i));
        }
        PASSWORD_CHARACTERS = characters.toArray(new Character[characters.size()]);
    }
}

