/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs;

import com.cabaret.security.certstore.certs.ICertificateImporter;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.processor.model.IProcessor;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.info.X500SimpleName;
import de.intarsys.security.certstore.library.core.CertificateLibrary;
import de.intarsys.security.certstore.node.CertStoreNodeFactory;
import de.intarsys.security.certstore.node.ICertStoreCertificateNode;
import de.intarsys.security.certstore.node.ICertStoreContainerNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.security.certstore.node.IMutableCertStoreContainerNode;
import de.intarsys.security.certstore.processor.CertificateStoreProcessorTools;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.transaction.ITransactionManager;
import de.intarsys.tools.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateImporter
extends CommonProcessor
implements ICertificateImporter {
    public static final String ARG_DEVICE = "device";
    public static final String ARG_DESTINATIONNODE = "destinationNode";
    public static final String ARG_DESTINATIONINDEX = "destinationIndex";
    public static final String ARG_NODENAME = "nodeName";
    public static final String ARG_TRUSTED = "trusted";
    public static final String ARG_SAVE = "save";
    public static final String DEFAULT_NODENAME = "${subjectLabel}";
    private static final Logger Log = LoggerFactory.getLogger(CertificateImporter.class);
    private ICertificateImporter device;

    protected static IMutableCertStoreContainerNode getArgCertificateContainerNode(IArgs args, String name) {
        Object object = args.get(name);
        if (object == null) {
            object = CertificateLibrary.get().getCertStoreNode();
        }
        if (object instanceof IMutableCertStoreContainerNode) {
            return (IMutableCertStoreContainerNode)object;
        }
        if (object instanceof String) {
            String nodePath = (String)object;
            return (IMutableCertStoreContainerNode)CertificateStoreProcessorTools.getCertificateContainerNode(nodePath, true);
        }
        throw new IllegalArgumentException(name);
    }

    public static ICertificateImporter getDevice(IArgs args) throws ObjectCreationException {
        ICertificateImporter importer = (ICertificateImporter)InstanceSpec.getAsInstance((IArgs)args, (String)ARG_DEVICE, IProcessor.class, null);
        if (importer == null) {
            throw new ObjectCreationException("illegal argument 'device'");
        }
        return importer;
    }

    public CertificateImporter(IFactory factory) {
        super(factory);
    }

    protected List<ICertStoreNode> basicImportEntries(List<IVirtualKeyStoreEntry> entries) throws Exception {
        ArrayList<ICertStoreNode> created = new ArrayList<ICertStoreNode>();
        IMutableCertStoreContainerNode parent = this.getDestinationNode();
        int labelIndex = 1;
        int index = this.getDestinationIndex();
        if (index < 0) {
            index = parent.size();
        }
        for (IVirtualKeyStoreEntry entry : entries) {
            VirtualKeyStore.get().addEntry(entry);
            if (this.isTrusted()) {
                entry.setTrusted(true);
            }
            ICertStoreCertificateNode node = CertStoreNodeFactory.get((ICertStoreContainerNode)parent).createCertificateNode(entry);
            node.setName(this.createNodeName(entry.getCertificate(), labelIndex));
            parent.addChild((ICertStoreNode)node, index++);
            created.add((ICertStoreNode)node);
            ++labelIndex;
        }
        return created;
    }

    protected void basicRun() throws Exception {
        this.getDevice().start();
        List entries = (List)this.getDevice().getResult();
        List<Object> created = null;
        if (entries == null) {
            created = Collections.emptyList();
        } else {
            ITransactionManager tm = TransactionManager.get();
            tm.begin();
            try {
                created = this.basicImportEntries(entries);
                tm.commit();
            }
            catch (Exception e) {
                Log.trace("Rollback transaction...");
                tm.rollback();
                throw e;
            }
        }
        this.setResult(created);
        if (this.isSave()) {
            // empty if block
        }
        this.ok();
    }

    protected String createNodeName(IX509Certificate certificate, int index) {
        MapResolver resolver = new MapResolver();
        resolver.put("subjectLabel", (Object)CertificateTools.getSubjectLabel((IX509Certificate)certificate));
        if (certificate.getIssuerX500Principal() != null) {
            resolver.put("issuer", (Object)new X500SimpleName(certificate.getIssuerX500Principal()));
        }
        if (certificate.getSubjectX500Principal() != null) {
            resolver.put("subject", (Object)new X500SimpleName(certificate.getSubjectX500Principal()));
        }
        resolver.put("index", (Object)index);
        TaggedStringEvaluator templateEvaluator = TaggedStringEvaluator.decorate((IStringEvaluator[])new IStringEvaluator[]{resolver, ExpressionEvaluator.get((Mode)Mode.UNTRUSTED)});
        return StringEvaluatorTools.evaluateString((IStringEvaluator)templateEvaluator, (String)this.getNodeName());
    }

    public int getDestinationIndex() {
        return ArgTools.getInt((IArgs)this.getArgs(), (String)ARG_DESTINATIONINDEX, (int)-1);
    }

    public IMutableCertStoreContainerNode getDestinationNode() {
        return CertificateImporter.getArgCertificateContainerNode(this.getArgs(), ARG_DESTINATIONNODE);
    }

    public ICertificateImporter getDevice() {
        return this.device;
    }

    public String getNodeName() {
        return ArgTools.getString((IArgs)this.getArgs(), (String)ARG_NODENAME, (String)DEFAULT_NODENAME);
    }

    public boolean isSave() {
        return ArgTools.getBool((IArgs)this.getArgs(), (String)ARG_SAVE, (boolean)true);
    }

    public boolean isTrusted() {
        return ArgTools.getBool((IArgs)this.getArgs(), (String)ARG_TRUSTED, (boolean)false);
    }

    public void setDevice(ICertificateImporter device) {
        this.device = device;
    }
}

