/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs;

import com.cabaret.security.certstore.certs.CommonCertificateImporter;
import com.cabaret.security.certstore.certs.IFileBasedCertificateImporter;
import com.cabaret.security.certstore.certs.PACKAGE;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;

public abstract class FileBasedCertificateImporter
extends CommonCertificateImporter
implements IFileBasedCertificateImporter {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private ILocator[] locators;

    public FileBasedCertificateImporter(IFactory factory) {
        super(factory);
    }

    @Override
    protected List<IVirtualKeyStoreEntry> importCertificates() throws Exception {
        ArrayList<IVirtualKeyStoreEntry> certificates = new ArrayList<IVirtualKeyStoreEntry>();
        try {
            for (ILocator locator : this.getLocators()) {
                certificates.addAll(this.importCertificates(locator));
            }
        }
        catch (GeneralSecurityException e) {
            String message = Msg.getString("FileBasedCertificateImporter.ErrorImport", new Object[0]);
            throw new Exception(message, e);
        }
        catch (IOException e) {
            String message = Msg.getString("FileBasedCertificateImporter.ErrorImport", new Object[0]);
            throw new Exception(message, e);
        }
        return certificates;
    }

    public ILocator[] getLocators() {
        return this.locators;
    }

    protected abstract List<IVirtualKeyStoreEntry> importCertificates(ILocator var1) throws IOException, GeneralSecurityException;

    public void setLocators(ILocator[] locators) {
        this.locators = locators;
    }
}

