/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.entity;

import com.cabaret.security.certstore.certs.CommonCertificateImporter;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.IFactory;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;

public class SimpleKeyImporter
extends CommonCertificateImporter {
    public static final String ARG_PRIVATEKEY = "privateKey";
    public static final String ARG_PASSWORD = "password";
    public static final String ARG_CERTIFICATECHAIN = "certificateChain";
    private PrivateKey privateKey;
    private IX509PublicKeyCertificate[] certificateChain;
    private Secret password;

    public SimpleKeyImporter(IFactory factory) {
        super(factory);
    }

    public IX509PublicKeyCertificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public Secret getPassword() {
        return this.password;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    protected List<IVirtualKeyStoreEntry> importCertificates() throws Exception {
        IVirtualKeyStoreEntry entry = VirtualKeyStore.get().createIDEntry(this.getPrivateKey(), this.getPassword(), this.getCertificateChain());
        ArrayList<IVirtualKeyStoreEntry> result = new ArrayList<IVirtualKeyStoreEntry>();
        result.add(entry);
        return result;
    }

    public void setCertificateChain(IX509PublicKeyCertificate[] certificateChain) {
        this.certificateChain = certificateChain;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }
}

