/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.generate;

import com.cabaret.security.certstore.certs.CommonCertificateImporter;
import com.cabaret.security.certstore.certs.generate.CertificateSigner;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.SignerTools;
import de.intarsys.security.certificate.creation.ICertificateSigner;
import de.intarsys.security.certificate.creation.RSAKeyPairFactory;
import de.intarsys.security.certificate.creation.X509PublicKeyCertificateCreator;
import de.intarsys.security.extension.IX509Extension;
import de.intarsys.security.extension.common.X509ExtensionAuthorityKeyIdentifier;
import de.intarsys.security.extension.common.X509ExtensionBasicConstraints;
import de.intarsys.security.extension.common.X509ExtensionExtendedKeyUsage;
import de.intarsys.security.extension.common.X509ExtensionKeyUsage;
import de.intarsys.security.extension.common.X509ExtensionSubjectKeyIdentifier;
import de.intarsys.security.privatekey.KeyCertificatePair;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GeneratedCertificateImporter
extends CommonCertificateImporter {
    public static final String ARG_COUNTRY = "country";
    public static final String ARG_EMAIL = "email";
    public static final String ARG_IDPASSWORD = "idPassword";
    public static final String ARG_KEYPAIR = "keyPair";
    public static final String ARG_KEY_SIZE = "keySize";
    public static final String ARG_LOCATION = "location";
    public static final String ARG_NAME = "name";
    public static final String ARG_GIVENNAME = "givenName";
    public static final String ARG_SURNAME = "surname";
    public static final String ARG_PSEUDONYM = "pseudonym";
    public static final String ARG_ORGANIZATION = "organization";
    public static final String ARG_ORGANIZATIONAL_UNIT = "organizationalUnit";
    public static final String ARG_STATE = "state";
    public static final String ARG_VALID_FROM = "validFrom";
    public static final String ARG_VALID_TO = "validTo";
    public static final String ARG_DIGESTER = "digester";
    public static final String ARG_KEY_USAGE = "keyUsage";
    public static final String ARG_EXTENDED_KEY_USAGE = "extendedKeyUsage";
    public static final String ARG_EXTENDED_KEY_USAGE_CRITICAL = "extendedKeyUsageCritical";
    public static final String ARG_CA = "ca";
    private String country;
    private String email;
    private String location;
    private String name;
    private String givenName;
    private String surname;
    private String pseudonym;
    private String organization;
    private String organizationalUnit;
    private Secret password;
    private String state;
    private Date validFrom;
    private Date validTo;
    private String digester;
    private int keyUsage;
    private List<String> extendedKeyUsage;
    private boolean extendedKeyUsageCritical;
    private boolean ca;
    private ISigner digestSigner;

    public static KeyPair getKeyPair(IArgs args) throws ObjectCreationException {
        Object argValue = args.get(ARG_KEYPAIR);
        if (argValue instanceof KeyPair) {
            return (KeyPair)argValue;
        }
        if (argValue instanceof IArgs) {
            InstanceSpec spec = InstanceSpec.createFromArgs(KeyPair.class, (Object)((IArgs)argValue));
            return (KeyPair)spec.createInstance();
        }
        return (KeyPair)FactoryTools.createInstance((Object)RSAKeyPairFactory.ID, (IArgs)args);
    }

    public static ISigner resolveDigestSigner(IArgs args) throws ObjectCreationException {
        return SignerTools.getSigner((IArgs)args, (String)"digestSigner");
    }

    public GeneratedCertificateImporter(IFactory factory) {
        super(factory);
    }

    protected void basicStop() throws Exception {
        super.basicStop();
        if (this.digestSigner != null) {
            this.digestSigner.dispose();
        }
    }

    protected KeyCertificatePair createEntity() throws Exception {
        X509PublicKeyCertificateCreator creator = new X509PublicKeyCertificateCreator();
        creator.setCountry(this.getCountry());
        creator.setEmail(this.getEmail());
        creator.setKeyPair(GeneratedCertificateImporter.getKeyPair(this.getArgs()));
        creator.setLocation(this.getLocation());
        creator.setName(this.getName());
        creator.setGivenName(this.getGivenName());
        creator.setSurname(this.getSurname());
        creator.setPseudonym(this.getPseudonym());
        creator.setOrganization(this.getOrganization());
        creator.setOrganizationalUnit(this.getOrganizationalUnit());
        creator.setState(this.getState());
        creator.setValidFrom(this.getValidFrom());
        creator.setValidTo(this.getValidTo());
        creator.setDigestAlgorithmName(this.getDigester());
        if (this.getKeyUsage() != 0) {
            creator.addExtension((IX509Extension)new X509ExtensionKeyUsage(this.getKeyUsage()));
        }
        if (this.getExtendedKeyUsage() != null) {
            X509ExtensionExtendedKeyUsage eku = new X509ExtensionExtendedKeyUsage(this.getExtendedKeyUsage());
            eku.setCritical(this.isExtendedKeyUsageCritical());
            creator.addExtension((IX509Extension)eku);
        }
        if (this.isCa()) {
            creator.addExtension((IX509Extension)new X509ExtensionBasicConstraints(true));
        }
        creator.addExtension((IX509Extension)new X509ExtensionSubjectKeyIdentifier());
        creator.addExtension((IX509Extension)new X509ExtensionAuthorityKeyIdentifier());
        if (this.getDigestSigner() != null) {
            creator.setSigner((ICertificateSigner)new CertificateSigner(this.getDigestSigner()));
        }
        return creator.createEntity();
    }

    public String getCountry() {
        return this.country;
    }

    public String getDigester() {
        return this.digester;
    }

    public ISigner getDigestSigner() {
        return this.digestSigner;
    }

    public String getEmail() {
        return this.email;
    }

    public List<String> getExtendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getPseudonym() {
        return this.pseudonym;
    }

    public String getState() {
        return this.state;
    }

    public String getSurname() {
        return this.surname;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    @Override
    protected List<IVirtualKeyStoreEntry> importCertificates() throws Exception {
        KeyCertificatePair entity = this.createEntity();
        IVirtualKeyStoreEntry entry = this.importEntry(entity);
        ArrayList<IVirtualKeyStoreEntry> result = new ArrayList<IVirtualKeyStoreEntry>();
        result.add(entry);
        return result;
    }

    protected IVirtualKeyStoreEntry importEntry(KeyCertificatePair entity) throws Exception {
        IVirtualKeyStoreEntry entry = VirtualKeyStore.get().createIDEntry(entity.getPrivateKey(), this.getPassword(), entity.getCertificateChain());
        return entry;
    }

    public boolean isCa() {
        return this.ca;
    }

    public boolean isExtendedKeyUsageCritical() {
        return this.extendedKeyUsageCritical;
    }

    public void setCa(boolean ca) {
        this.ca = ca;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setDigester(String digestAlgorithmName) {
        this.digester = digestAlgorithmName;
    }

    public void setDigestSigner(ISigner digestSigner) {
        this.digestSigner = digestSigner;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setExtendedKeyUsage(List<String> extendedKeyUsage) {
        this.extendedKeyUsage = extendedKeyUsage;
    }

    public void setExtendedKeyUsageCritical(boolean extendedKeyUsageCritical) {
        this.extendedKeyUsageCritical = extendedKeyUsageCritical;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setKeyUsage(int keyUsage) {
        this.keyUsage = keyUsage;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public void setPseudonym(String pseudonym) {
        this.pseudonym = pseudonym;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public void setValidTo(Date validTo) {
        this.validTo = validTo;
    }
}

