/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.generate;

import de.intarsys.security.extension.IX509Extension;
import de.intarsys.security.extension.common.X509ExtensionBasicConstraints;
import de.intarsys.security.extension.common.X509ExtensionExtendedKeyUsage;
import de.intarsys.security.extension.common.X509ExtensionKeyUsage;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class KeyUsageSetting
extends EnumItem {
    public static final EnumMeta<KeyUsageSetting> META = KeyUsageSetting.getMeta(KeyUsageSetting.class);
    public static final KeyUsageSetting digitalSignature = new KeyUsageSetting("digitalSignature", 0);
    public static final KeyUsageSetting crypt = new KeyUsageSetting("crypt", 1);
    public static final KeyUsageSetting ca = new KeyUsageSetting("ca", 2);
    public static final KeyUsageSetting tsa = new KeyUsageSetting("tsa", 3);
    public static final KeyUsageSetting sslServer = new KeyUsageSetting("sslServer", 4);
    private List<IX509Extension> extensions = new ArrayList<IX509Extension>();

    public KeyUsageSetting(String id, int weight) {
        super(id, weight);
    }

    protected void addExtension(IX509Extension extension) {
        this.extensions.add(extension);
    }

    public List<IX509Extension> getExtensions() {
        return this.extensions;
    }

    static {
        digitalSignature.setDefault();
        X509ExtensionKeyUsage ku = new X509ExtensionKeyUsage();
        ku.addUsageDigitalSignature();
        X509ExtensionExtendedKeyUsage eku = new X509ExtensionExtendedKeyUsage();
        eku.addUsage(KeyPurposeId.id_kp_clientAuth.getId());
        eku.addUsage(KeyPurposeId.id_kp_emailProtection.getId());
        digitalSignature.addExtension((IX509Extension)ku);
        digitalSignature.addExtension((IX509Extension)eku);
        ku = new X509ExtensionKeyUsage();
        ku.addUsageDataEncipherment();
        ku.addUsageKeyEncipherment();
        crypt.addExtension((IX509Extension)ku);
        ku = new X509ExtensionKeyUsage();
        ku.addUsageKeyCertSign();
        ku.addUsageCRLSign();
        ca.addExtension((IX509Extension)ku);
        X509ExtensionBasicConstraints bc = new X509ExtensionBasicConstraints(true);
        ca.addExtension((IX509Extension)bc);
        ku = new X509ExtensionKeyUsage();
        ku.addUsageDigitalSignature();
        eku = new X509ExtensionExtendedKeyUsage();
        eku.addUsage(KeyPurposeId.id_kp_timeStamping.getId());
        eku.setCritical(true);
        tsa.addExtension((IX509Extension)ku);
        tsa.addExtension((IX509Extension)eku);
        ku = new X509ExtensionKeyUsage();
        ku.addUsageKeyAgreement();
        ku.addUsageKeyEncipherment();
        eku = new X509ExtensionExtendedKeyUsage();
        eku.addUsage(KeyPurposeId.id_kp_serverAuth.getId());
        sslServer.addExtension((IX509Extension)ku);
        sslServer.addExtension((IX509Extension)eku);
    }
}

