/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.http;

import com.cabaret.security.certstore.certs.CommonCertificateImporter;
import com.cabaret.security.certstore.certs.http.PACKAGE;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.ssl.SslContextProvider;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPCertificateImporter
extends CommonCertificateImporter {
    public static final String ARG_URL = "url";
    public static final String ARG_HOSTNAMEVERIFIER = "hostnameVerifier";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(HTTPCertificateImporter.class);
    private String url;
    private HostnameVerifier hostnameVerifier;

    public HTTPCertificateImporter(IFactory factory) {
        super(factory);
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public SSLContext getSslContext() {
        try {
            return SslContextProvider.get().createSslContext();
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    protected List<IVirtualKeyStoreEntry> importCertificates() throws Exception {
        IX509Certificate certificate = this.retrieveCertificate();
        IVirtualKeyStoreEntry entry = this.importEntry(certificate);
        ArrayList<IVirtualKeyStoreEntry> result = new ArrayList<IVirtualKeyStoreEntry>();
        result.add(entry);
        return result;
    }

    protected IVirtualKeyStoreEntry importEntry(IX509Certificate certificate) throws IOException, GeneralSecurityException {
        return VirtualKeyStore.get().createCertificateEntry(certificate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IX509Certificate retrieveCertificate() throws IOException, GeneralSecurityException {
        int responseCode;
        HttpURLConnection con = (HttpURLConnection)new URL(this.url).openConnection();
        if (con instanceof HttpsURLConnection) {
            if (this.getSslContext() != null) {
                ((HttpsURLConnection)con).setSSLSocketFactory(this.getSslContext().getSocketFactory());
            }
            if (this.getHostnameVerifier() != null) {
                ((HttpsURLConnection)con).setHostnameVerifier(this.getHostnameVerifier());
            }
        }
        if ((responseCode = con.getResponseCode()) != 200) {
            String responseMsg = con.getResponseMessage();
            throw new IOException("Bad Response: " + responseCode + " (" + responseMsg + ")");
        }
        InputStream in = null;
        try {
            in = (InputStream)con.getContent();
            IX509Certificate iX509Certificate = X509CertificateFactory.get().createCertificate(in);
            return iX509Certificate;
        }
        finally {
            StreamTools.close((Closeable)in);
        }
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

