/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.keystore;

import com.cabaret.security.certstore.certs.FileBasedCertificateImporter;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.keystore.CommonKeyStore;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.security.virtualkeystore.core.ICertificateResolver;
import de.intarsys.security.virtualkeystore.core.IPrivateKeyResolver;
import de.intarsys.security.virtualkeystore.resolver.CERResolver;
import de.intarsys.security.virtualkeystore.resolver.JKSResolver;
import de.intarsys.security.virtualkeystore.resolver.PEMResolver;
import de.intarsys.security.virtualkeystore.resolver.PKCS12Resolver;
import de.intarsys.security.virtualkeystore.resolver.PKCS7Resolver;
import de.intarsys.security.virtualkeystore.resolver.SimpleResolver;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.util.Collections;
import java.util.List;

public abstract class CommonKeystoreImporter
extends FileBasedCertificateImporter {
    public static final String ARG_ALIASES = "aliases";
    public static final String ARG_SELECTORS = "selectors";
    public static final String ARG_STOREPASSWORD = "storePassword";
    private Secret storePassword;

    protected CommonKeystoreImporter(IFactory factory) {
        super(factory);
    }

    protected ICertificateResolver createCertificateResolver(ILocator locator, IX509Certificate certificate) {
        if (KeyStoreFacade.isJKS((ILocator)locator)) {
            JKSResolver resolver = new JKSResolver(locator, ((IX509PublicKeyCertificate)certificate).getAlias());
            return resolver;
        }
        if (KeyStoreFacade.isPKCS12((ILocator)locator)) {
            PKCS12Resolver resolver = new PKCS12Resolver(locator);
            resolver.setAlias(((IX509PublicKeyCertificate)certificate).getAlias());
            resolver.setPassword(this.getStorePassword());
            return resolver;
        }
        if (KeyStoreFacade.isCER((ILocator)locator)) {
            CERResolver resolver = new CERResolver(locator);
            return resolver;
        }
        if (CommonKeyStore.isATZ((ILocator)locator)) {
            CERResolver resolver = new CERResolver(locator);
            return resolver;
        }
        if (CommonKeyStore.isCRY((ILocator)locator)) {
            SimpleResolver resolver = new SimpleResolver(certificate, null);
            return resolver;
        }
        if (KeyStoreFacade.isPEM((ILocator)locator)) {
            PEMResolver resolver = new PEMResolver(locator);
            return resolver;
        }
        if (KeyStoreFacade.isPKCS7((ILocator)locator)) {
            PKCS7Resolver resolver = new PKCS7Resolver(locator, ((IX509PublicKeyCertificate)certificate).getAlias());
            return resolver;
        }
        return null;
    }

    protected IPrivateKeyResolver createKeyResolver(ILocator locator, IX509Certificate certificate) {
        if (KeyStoreFacade.isJKS((ILocator)locator)) {
            JKSResolver resolver = new JKSResolver(locator, ((IX509PublicKeyCertificate)certificate).getAlias());
            return resolver;
        }
        if (KeyStoreFacade.isPKCS12((ILocator)locator)) {
            PKCS12Resolver resolver = new PKCS12Resolver(locator);
            resolver.setAlias(((IX509PublicKeyCertificate)certificate).getAlias());
            resolver.setPassword(this.getStorePassword());
            return resolver;
        }
        return null;
    }

    protected List<IX509Certificate> getCertificates(IKeyStore keyStore) throws ObjectCreationException {
        if (this.getArgs().get(ARG_SELECTORS) == null) {
            return null;
        }
        return CertificateProviderTools.getCertificates((IArgs)this.getArgs(), (String)ARG_SELECTORS, (ICertificateProvider)keyStore.getCertificateProvider(), null, null);
    }

    protected List<IX509Certificate> getDefaultCertificates(IKeyStore keyStore) throws ObjectCreationException {
        return Collections.emptyList();
    }

    protected List<IX509Certificate> getSelectedCertificates(ILocator locator) throws KeyStoreException, IOException {
        try {
            IKeyStore facade = KeyStoreFactory.get().create(locator);
            facade.load(this.getStorePassword());
            List<IX509Certificate> certificates = this.getCertificates(facade);
            if (certificates == null) {
                certificates = this.getDefaultCertificates(facade);
            }
            return certificates;
        }
        catch (ObjectCreationException e) {
            throw new IOException(e);
        }
    }

    public Secret getStorePassword() {
        return this.storePassword;
    }

    public void setStorePassword(Secret storePassword) {
        this.storePassword = storePassword;
    }
}

