/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.keystore;

import com.cabaret.security.certstore.certs.FileBasedCertificateImporter;
import com.cabaret.security.certstore.certs.FileBasedCertificateImporterFactory;
import com.cabaret.security.certstore.certs.keystore.CommonKeystoreImporter;
import com.cabaret.security.certstore.certs.keystore.PACKAGE;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.file.FileExtension;
import de.intarsys.tools.file.FileExtensionSet;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class CommonKeystoreImporterFactory
extends FileBasedCertificateImporterFactory {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static void fillFileFilter(FileExtensionSet set, List<String> extensions, List<String> names) {
        for (FileExtension extension : set.getFileExtensions()) {
            names.add(extension.getLabel());
            StringBuilder commonExt = new StringBuilder();
            Iterator j = extension.getExtensions().iterator();
            while (j.hasNext()) {
                String ext = (String)j.next();
                commonExt.append("*.").append(ext);
                if (!j.hasNext()) continue;
                commonExt.append(";");
            }
            extensions.add(commonExt.toString());
        }
    }

    public static FileExtension getFileExtensionAllTemplate() {
        FileExtension extension = new FileExtension(Msg.getString("CommonKeystoreImporterFactory.FileDescriptionAll", new Object[0]));
        return extension;
    }

    public static FileExtension getFileExtensionATZ() {
        FileExtension extension = new FileExtension(Msg.getString("CommonKeystoreImporterFactory.FileDescriptionATZ", new Object[0]));
        extension.addAllExtensions(Arrays.asList(KeyStoreFacade.TYPES_ATZ));
        return extension;
    }

    public static FileExtension getFileExtensionCER() {
        FileExtension extension = new FileExtension(Msg.getString("CommonKeystoreImporterFactory.FileDescriptionCER", new Object[0]));
        extension.addAllExtensions(Arrays.asList(KeyStoreFacade.TYPES_X509));
        return extension;
    }

    public static FileExtension getFileExtensionCRY() {
        FileExtension extension = new FileExtension(Msg.getString("CommonKeystoreImporterFactory.FileDescriptionCRY", new Object[0]));
        extension.addAllExtensions(Arrays.asList(KeyStoreFacade.TYPES_CRY));
        return extension;
    }

    public static FileExtension getFileExtensionJKS() {
        FileExtension extension = new FileExtension(Msg.getString("CommonKeystoreImporterFactory.FileDescriptionJKS", new Object[0]));
        extension.addAllExtensions(Arrays.asList(KeyStoreFacade.TYPES_JKS));
        return extension;
    }

    public static FileExtension getFileExtensionPEM() {
        FileExtension extension = new FileExtension(Msg.getString("CommonKeystoreImporterFactory.FileDescriptionPEM", new Object[0]));
        extension.addAllExtensions(Arrays.asList(KeyStoreFacade.TYPES_PEM));
        return extension;
    }

    public static FileExtension getFileExtensionPKCS12() {
        FileExtension extension = new FileExtension(Msg.getString("CommonKeystoreImporterFactory.FileDescriptionPKCS12", new Object[0]));
        extension.addAllExtensions(Arrays.asList(KeyStoreFacade.TYPES_PKCS12));
        return extension;
    }

    public static FileExtension getFileExtensionPKCS7() {
        FileExtension extension = new FileExtension(Msg.getString("CommonKeystoreImporterFactory.FileDescriptionPKCS7", new Object[0]));
        extension.addAllExtensions(Arrays.asList(KeyStoreFacade.TYPES_PKCS7));
        return extension;
    }

    protected CommonKeystoreImporterFactory() {
    }

    @Override
    protected FileBasedCertificateImporter basicCreateImporter(IArgs args) {
        CommonKeystoreImporter importer = this.basicCreateKeystoreImporter(args);
        Secret storePassword = ArgTools.getSecretHide((IArgs)args, (String)"storePassword", (Secret)Secret.EMPTY);
        importer.setStorePassword(storePassword);
        return importer;
    }

    protected abstract CommonKeystoreImporter basicCreateKeystoreImporter(IArgs var1);
}

