/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.keystore;

import com.cabaret.security.certstore.certs.keystore.CommonKeystoreImporter;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.AllCertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KeystoreCertificateImporter
extends CommonKeystoreImporter {
    public KeystoreCertificateImporter(IFactory factory) {
        super(factory);
    }

    @Override
    protected List<IX509Certificate> getDefaultCertificates(IKeyStore keyStore) throws ObjectCreationException {
        return ListTools.toList((Iterator)keyStore.getCertificateProvider().lookupCertificates((IX509CertificateFilter)AllCertificateFilter.UNIQUE));
    }

    @Override
    protected List<IVirtualKeyStoreEntry> importCertificates(ILocator locator) throws IOException, GeneralSecurityException {
        ArrayList<IVirtualKeyStoreEntry> result = new ArrayList<IVirtualKeyStoreEntry>();
        List<IX509Certificate> certificates = this.getSelectedCertificates(locator);
        for (IX509Certificate certificate : certificates) {
            IVirtualKeyStoreEntry entry = VirtualKeyStore.get().createCertificateEntry(certificate);
            result.add(entry);
        }
        return result;
    }
}

