/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.keystore;

import com.cabaret.security.certstore.certs.keystore.CommonKeystoreImporter;
import com.cabaret.security.certstore.certs.keystore.PACKAGE;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.virtualkeystore.core.IPrivateKeyResolver;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KeystoreIDCertificateImporter
extends CommonKeystoreImporter {
    public static final String ARG_IDPASSWORD = "idPassword";
    public static final String ARG_IDPASSWORDNEW = "idPasswordNew";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Secret idPassword;
    private Secret idPasswordNew;
    private boolean copy;

    public KeystoreIDCertificateImporter(IFactory factory) {
        super(factory);
    }

    @Override
    protected List<IX509Certificate> getDefaultCertificates(IKeyStore keyStore) throws ObjectCreationException {
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setHasPrivateKey(Boolean.valueOf(true));
        return ListTools.toList((Iterator)keyStore.getCertificateProvider().lookupCertificates((IX509CertificateFilter)selector));
    }

    public Secret getIdPassword() {
        return this.idPassword;
    }

    public Secret getIdPasswordNew() {
        if (this.idPasswordNew == null) {
            this.idPasswordNew = this.getIdPassword();
        }
        if (this.idPasswordNew == null) {
            this.idPasswordNew = this.getStorePassword();
        }
        return this.idPasswordNew;
    }

    @Override
    protected List<IVirtualKeyStoreEntry> importCertificates(ILocator locator) throws IOException, GeneralSecurityException {
        ArrayList<IVirtualKeyStoreEntry> result = new ArrayList<IVirtualKeyStoreEntry>();
        List<IX509Certificate> certificates = this.getSelectedCertificates(locator);
        for (IX509Certificate certificate : certificates) {
            IPrivateKeyResolver resolver = this.createKeyResolver(locator, certificate);
            IVirtualKeyStoreEntry entry = null;
            if (this.isCopy()) {
                if (this.getIdPassword().isEmpty()) {
                    URI copyUri = VirtualKeyStore.get().storeCopy(resolver.toLocator());
                    try {
                        URI originalUri = new URI(resolver.toURI());
                        String query = originalUri.getRawQuery();
                        if (!StringTools.isEmpty((String)query)) {
                            copyUri = new URI(copyUri.toString() + "?" + query);
                        }
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(e);
                    }
                    entry = VirtualKeyStore.get().createIDEntry(copyUri.toString(), new IX509PublicKeyCertificate[]{(IX509PublicKeyCertificate)certificate});
                } else {
                    PrivateKey key = resolver.getPrivateKey(this.getIdPassword());
                    entry = VirtualKeyStore.get().createIDEntry(key, this.getIdPasswordNew(), new IX509PublicKeyCertificate[]{(IX509PublicKeyCertificate)certificate});
                }
            } else {
                entry = VirtualKeyStore.get().createIDEntry(resolver.toURI(), new IX509PublicKeyCertificate[]{(IX509PublicKeyCertificate)certificate});
            }
            result.add(entry);
        }
        return result;
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public void setIdPassword(Secret idPassword) {
        this.idPassword = idPassword;
    }

    public void setIdPasswordNew(Secret idPasswordNew) {
        this.idPasswordNew = idPasswordNew;
    }
}

