/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.keystore;

import com.cabaret.security.certstore.certs.keystore.CommonKeystoreImporter;
import com.cabaret.security.certstore.certs.keystore.CommonKeystoreImporterFactory;
import com.cabaret.security.certstore.certs.keystore.KeystoreIDCertificateImporter;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.file.FileExtension;
import de.intarsys.tools.file.FileExtensionSet;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.util.Arrays;

public class KeystoreIDCertificateImporterFactory
extends CommonKeystoreImporterFactory {
    public static final String ID = KeystoreIDCertificateImporterFactory.class.getName();

    @Override
    protected CommonKeystoreImporter basicCreateKeystoreImporter(IArgs args) {
        KeystoreIDCertificateImporter importer = new KeystoreIDCertificateImporter(this);
        Secret idPassword = ArgTools.getSecretHide((IArgs)args, (String)"idPassword", (Secret)Secret.EMPTY);
        importer.setIdPassword(idPassword);
        Secret idPasswordNew = ArgTools.getSecretHide((IArgs)args, (String)"idPasswordNew", (Secret)Secret.EMPTY);
        importer.setIdPasswordNew(idPasswordNew);
        boolean copy = ArgTools.getBool((IArgs)args, (String)"copy", (boolean)true);
        importer.setCopy(copy);
        return importer;
    }

    @Override
    public FileExtensionSet getSupportedFileExtensions() {
        FileExtensionSet set = new FileExtensionSet();
        set.addExtension(KeystoreIDCertificateImporterFactory.getFileExtensionJKS());
        set.addExtension(KeystoreIDCertificateImporterFactory.getFileExtensionPKCS12());
        FileExtension extension = KeystoreIDCertificateImporterFactory.getFileExtensionAllTemplate();
        extension.addAllExtensions(Arrays.asList(KeyStoreFacade.TYPES_JKS));
        extension.addAllExtensions(Arrays.asList(KeyStoreFacade.TYPES_PKCS12));
        set.addExtension(extension);
        return set;
    }
}

