/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.certs.pem;

import com.cabaret.security.certstore.certs.CommonCertificateImporter;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.openssl.PEMTools;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.locator.ILocator;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;

public class PEMKeyImporter
extends CommonCertificateImporter {
    public static final String ARG_PRIVATEKEY_LOCATOR = "privateKeyLocator";
    public static final String ARG_CERTIFICATE_LOCATOR = "certificateLocator";
    public static final String ARG_PASSWORD = "passsword";
    private ILocator privateKeyLocator;
    private ILocator certificateLocator;
    private Secret password;

    public PEMKeyImporter(IFactory factory) {
        super(factory);
    }

    public ILocator getCertificateLocator() {
        return this.certificateLocator;
    }

    public Secret getPassword() {
        return this.password;
    }

    public ILocator getPrivateKeyLocator() {
        return this.privateKeyLocator;
    }

    @Override
    protected List<IVirtualKeyStoreEntry> importCertificates() throws Exception {
        IX509PublicKeyCertificate certificate = PEMTools.readPEMCertificate((ILocator)this.getCertificateLocator());
        KeyPair keyPair = PEMTools.readPEMKeyPair((ILocator)this.getPrivateKeyLocator(), (IPasswordProvider)new IPasswordProvider(){

            public Secret getPassword() {
                return PEMKeyImporter.this.getPassword();
            }
        });
        PrivateKey privateKey = keyPair.getPrivate();
        IVirtualKeyStoreEntry entry = VirtualKeyStore.get().createIDEntry(privateKey, this.getPassword(), new IX509PublicKeyCertificate[]{certificate});
        ArrayList<IVirtualKeyStoreEntry> result = new ArrayList<IVirtualKeyStoreEntry>();
        result.add(entry);
        return result;
    }

    public void setCertificateLocator(ILocator certificateLocator) {
        this.certificateLocator = certificateLocator;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public void setPrivateKeyLocator(ILocator privateKeyLocator) {
        this.privateKeyLocator = privateKeyLocator;
    }
}

