/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.certstore.export;

import com.cabaret.security.certstore.export.CommonCertificateNodeExporter;
import com.cabaret.security.certstore.export.IKeyAccess;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certstore.node.CertStoreNodeTools;
import de.intarsys.security.certstore.node.ICertStoreCertificateNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.security.virtualkeystore.core.IPrivateKeySupport;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import java.security.PrivateKey;

public class X509CertificateNodeExporter
extends CommonCertificateNodeExporter {
    public X509CertificateNodeExporter(IFactory factory) {
        super(factory);
    }

    @Override
    protected void fillDeviceArgs(IArgs deviceArgs) throws Exception {
        deviceArgs.put("certificate", (Object)this.getCertificate());
        deviceArgs.put("privateKey", (Object)this.getPrivateKey());
    }

    protected IX509Certificate getCertificate() throws Exception {
        return this.getNode().getCertificate();
    }

    public ICertStoreCertificateNode getNode() {
        return (ICertStoreCertificateNode)super.getNode();
    }

    protected IKeyAccess getPrivateKey() throws Exception {
        return new IKeyAccess(){

            @Override
            public PrivateKey getKey(Secret password) throws Exception {
                IPrivateKeySupport privateKeySupport = CertStoreNodeTools.getPrivateKeySupport((ICertStoreNode)X509CertificateNodeExporter.this.getNode());
                if (privateKeySupport == null || !privateKeySupport.canExportKey()) {
                    throw new IllegalStateException("No key available.");
                }
                return privateKeySupport.getPrivateKey(password);
            }

            @Override
            public boolean verifyPassword(Secret password) {
                try {
                    return this.getKey(password) != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
    }
}

