/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.security.x509download.processor;

import com.cabaret.security.x509download.processor.PACKAGE;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.common.CommonCertificateProvider;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certstore.library.core.CertificateLibrary;
import de.intarsys.security.certstore.node.CertStoreNodeTools;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.security.certstore.node.IMutableCertStoreContainerNode;
import de.intarsys.security.certstore.processor.CertificateStoreProcessorTools;
import de.intarsys.security.x509download.X509DownloadEnvironment;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ConfiguredCertificateProvider
extends CommonCertificateProvider {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public boolean containsCertificate(IX509Certificate certificate) {
        if (!X509DownloadEnvironment.get().isDownloadCertificates()) {
            return false;
        }
        return X509DownloadEnvironment.get().getProvider().containsCertificate(certificate);
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        if (!X509DownloadEnvironment.get().isDownloadCertificates()) {
            return Collections.emptyIterator();
        }
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector selector = (IX509CertificateSelector)filter;
            if (selector.hasPrivateKey() != null && selector.hasPrivateKey().booleanValue()) {
                return Collections.emptyIterator();
            }
            IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
            if (serviceTypeSelector != null && serviceTypeSelector.isTrustedOnly()) {
                return Collections.emptyIterator();
            }
        }
        List result = ListTools.toList(X509DownloadEnvironment.get().getProvider().lookupCertificates(filter));
        this.storeCertificates(result);
        return result.iterator();
    }

    protected void storeCertificates(Collection<IX509Certificate> certificates) {
        if (!X509DownloadEnvironment.get().isStoreDownloadedCertificates()) {
            return;
        }
        String groupName = Msg.getString("ConfiguredCertificateProvider.groupNameDownloadedCerts", new Object[0]);
        IMutableCertStoreContainerNode libraryNode = (IMutableCertStoreContainerNode)CertificateLibrary.get().getCertStoreNode();
        for (IX509Certificate certificate : certificates) {
            try {
                if (CertStoreNodeTools.findNode((ICertStoreNode)libraryNode, (IX509Certificate)certificate, (boolean)false) != null) continue;
                CertificateStoreProcessorTools.importCertificate(certificate, null, groupName, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

