/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.processor;

import com.cabaret.security.certstore.certs.CertificateImporterFactory;
import com.cabaret.security.certstore.certs.entity.SimpleCertificateImporterFactory;
import com.cabaret.security.certstore.certs.entity.SimpleKeyImporterFactory;
import com.cabaret.security.certstore.certs.keystore.KeystoreCertificateImporterFactory;
import com.cabaret.security.certstore.certs.keystore.KeystoreIDCertificateImporterFactory;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.security.certstore.library.core.CertificateLibrary;
import de.intarsys.security.certstore.node.CertStoreNodeFactory;
import de.intarsys.security.certstore.node.CertStoreNodeTools;
import de.intarsys.security.certstore.node.ICertStoreContainerNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.security.certstore.node.IMutableCertStoreContainerNode;
import de.intarsys.security.privatekey.PrivateKeyTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateStoreProcessorTools {
    private static final Logger Log = LoggerFactory.getLogger(CertificateStoreProcessorTools.class);

    protected static IMutableCertStoreContainerNode createGroupNode(IMutableCertStoreContainerNode parent, String path) {
        String localName = null;
        String tail = null;
        int delimIndex = path.indexOf("/");
        if (delimIndex < 0) {
            localName = path;
        } else {
            localName = path.substring(0, delimIndex);
            tail = path.substring(delimIndex + 1);
        }
        IMutableCertStoreContainerNode node = null;
        if (StringTools.isEmpty((String)localName)) {
            node = parent;
        } else {
            ICertStoreNode child = parent.getChild(localName);
            if (child != null && !(child instanceof IMutableCertStoreContainerNode)) {
                throw new IllegalArgumentException("invalid node name - no group: " + localName);
            }
            node = (IMutableCertStoreContainerNode)child;
            if (node == null) {
                IMutableCertStoreContainerNode group = CertStoreNodeFactory.get((ICertStoreContainerNode)parent).createContainerNode();
                group.setName(localName);
                parent.addChild((ICertStoreNode)group);
                node = group;
            }
        }
        if (StringTools.isEmpty((String)tail)) {
            return node;
        }
        return CertificateStoreProcessorTools.createGroupNode(node, tail);
    }

    public static ICertStoreContainerNode getCertificateContainerNode(ICertStoreContainerNode parent, String nodePath, boolean create) {
        ICertStoreContainerNode node = (ICertStoreContainerNode)parent.get(nodePath);
        if (node == null && create && parent instanceof IMutableCertStoreContainerNode) {
            node = CertificateStoreProcessorTools.createGroupNode((IMutableCertStoreContainerNode)parent, nodePath);
        }
        return node;
    }

    public static ICertStoreContainerNode getCertificateContainerNode(String nodePath, boolean create) {
        ICertStoreContainerNode library = CertificateLibrary.get().getCertStoreNode();
        return CertificateStoreProcessorTools.getCertificateContainerNode(library, nodePath, create);
    }

    public static List<ICertStoreNode> importAll(ILocator locator, IMutableCertStoreContainerNode parentNode) throws KeyStoreException, IOException {
        final Set excluded = CertStoreNodeTools.getCertificates((ICertStoreNode)parentNode);
        IX509CertificateFilter filter = new IX509CertificateFilter(){

            public boolean accept(IX509Certificate certificate) {
                return !excluded.contains(certificate);
            }

            public boolean isX509NonRepudiation() {
                return false;
            }
        };
        IKeyStore facade = KeyStoreFactory.get().create(locator);
        facade.load();
        ArrayList<IX509Certificate> keySelectors = new ArrayList<IX509Certificate>();
        ArrayList<IX509Certificate> certSelectors = new ArrayList<IX509Certificate>();
        Iterator i = facade.getCertificateProvider().lookupCertificates(filter);
        while (i.hasNext()) {
            IX509Certificate entity = (IX509Certificate)i.next();
            if (entity instanceof IX509PublicKeyCertificate && PrivateKeyTools.hasPrivateKey((IX509PublicKeyCertificate)((IX509PublicKeyCertificate)entity))) {
                keySelectors.add(entity);
                continue;
            }
            certSelectors.add(entity);
        }
        ArrayList<ICertStoreNode> result = new ArrayList<ICertStoreNode>();
        result.addAll(CertificateStoreProcessorTools.importKeys(locator, keySelectors, parentNode));
        result.addAll(CertificateStoreProcessorTools.importCertificates(locator, certSelectors, parentNode));
        return result;
    }

    public static List<ICertStoreNode> importAll(ILocator locator, String parentPath) throws KeyStoreException, IOException {
        IMutableCertStoreContainerNode parentNode = (IMutableCertStoreContainerNode)CertificateStoreProcessorTools.getCertificateContainerNode(parentPath, true);
        return CertificateStoreProcessorTools.importAll(locator, parentNode);
    }

    public static ICertStoreNode importCertificate(IX509Certificate certificate, String name, Object parentNodeOrPath, boolean trusted) throws Exception {
        Args args = Args.create();
        args.put("nodeName", (Object)name);
        args.put("destinationNode", parentNodeOrPath);
        args.put("trusted", (Object)trusted);
        InstanceSpec specDevice = InstanceSpec.createFromFactory(Object.class, (Object)SimpleCertificateImporterFactory.ID, (Object)Args.create());
        specDevice.getArgs().put("certificate", (Object)certificate);
        InstanceSpec.put((IArgs)args, (String)"device", (Object)specDevice);
        List result = (List)FunctorTools.perform((Object)CertificateImporterFactory.ID, (IArgs)args);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (ICertStoreNode)result.get(0);
    }

    private static List<ICertStoreNode> importCertificates(ILocator locator, List<IX509Certificate> selectors, IMutableCertStoreContainerNode parentNode) {
        if (selectors.isEmpty()) {
            return Collections.emptyList();
        }
        Args args = Args.create();
        args.put("destinationNode", (Object)parentNode);
        InstanceSpec specDevice = InstanceSpec.createFromFactory(Object.class, (Object)KeystoreCertificateImporterFactory.ID, (Object)Args.create());
        specDevice.getArgs().put("locator", (Object)locator);
        specDevice.getArgs().put("selectors", selectors);
        specDevice.getArgs().put("copy", (Object)Boolean.FALSE);
        InstanceSpec.put((IArgs)args, (String)"device", (Object)specDevice);
        try {
            return (List)FunctorTools.perform((Object)CertificateImporterFactory.ID, (IArgs)args);
        }
        catch (FunctorException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static ICertStoreNode importKey(PrivateKey key, Secret password, IX509PublicKeyCertificate certificate, String name, Object parentNodeOrPath, boolean trusted) throws Exception {
        Args args = Args.create();
        args.put("nodeName", (Object)name);
        args.put("destinationNode", parentNodeOrPath);
        args.put("trusted", (Object)trusted);
        InstanceSpec specDevice = InstanceSpec.createFromFactory(Object.class, (Object)SimpleKeyImporterFactory.ID, (Object)Args.create());
        specDevice.getArgs().put("certificateChain", (Object)certificate);
        specDevice.getArgs().put("privateKey", (Object)key);
        specDevice.getArgs().put("password", (Object)password);
        InstanceSpec.put((IArgs)args, (String)"device", (Object)specDevice);
        List result = (List)FunctorTools.perform((Object)CertificateImporterFactory.ID, (IArgs)args);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (ICertStoreNode)result.get(0);
    }

    private static List<ICertStoreNode> importKeys(ILocator locator, List<IX509Certificate> selectors, IMutableCertStoreContainerNode parentNode) {
        if (selectors.isEmpty()) {
            return Collections.emptyList();
        }
        Args args = Args.create();
        args.put("destinationNode", (Object)parentNode);
        InstanceSpec specDevice = InstanceSpec.createFromFactory(Object.class, (Object)KeystoreIDCertificateImporterFactory.ID, (Object)Args.create());
        specDevice.getArgs().put("locator", (Object)locator);
        specDevice.getArgs().put("selectors", selectors);
        specDevice.getArgs().put("copy", (Object)Boolean.TRUE);
        InstanceSpec.put((IArgs)args, (String)"device", (Object)specDevice);
        try {
            return (List)FunctorTools.perform((Object)CertificateImporterFactory.ID, (IArgs)args);
        }
        catch (FunctorException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static boolean isValidLocation(String groupName) {
        boolean ret = false;
        try {
            ret = CertificateStoreProcessorTools.getCertificateContainerNode(groupName, true) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

