/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.x509download;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certstore.ldap.LDAPCertStoreParameters;
import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.IX509CRLSelector;
import de.intarsys.security.crl.common.CrlTools;
import de.intarsys.security.ldap.LDAPAddress;
import de.intarsys.security.validation.IOrigin;
import de.intarsys.security.validation.IOriginProvider;
import de.intarsys.security.validation.Origin;
import de.intarsys.security.x509download.LDAPServerList;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LDAPBasedX509Provider
implements ICRLProvider,
ICertificateProvider,
IOriginProvider<IX509CRL> {
    private static final Attribute ATTR_URL = new Attribute("url");
    private final Map<LDAPAddress, CertStore> certStores = new HashMap<LDAPAddress, CertStore>();
    private final LDAPServerList urls;
    private EventDispatcher dispatcher;

    public LDAPBasedX509Provider(LDAPServerList urls) {
        this.urls = urls;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher((Object)this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    public boolean containsCertificate(IX509Certificate certificate) {
        return false;
    }

    private CertStore getCertStore(LDAPAddress url) {
        CertStore store = this.certStores.get(url);
        if (store != null) {
            return store;
        }
        LDAPCertStoreParameters params = new LDAPCertStoreParameters(url);
        try {
            store = CertStore.getInstance("LDAP", (CertStoreParameters)params, "intarsys");
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (store == null) {
            store = CertificateTools.createJavaCertStore((Collection)Collections.EMPTY_SET);
        }
        this.certStores.put(url, store);
        return store;
    }

    public IOrigin getOrigin(IX509CRL crl) {
        String url = null;
        if (crl instanceof IAttributeSupport) {
            url = (String)((IAttributeSupport)crl).getAttribute((Object)ATTR_URL);
        }
        if (url == null) {
            return Origin.undefined();
        }
        return Origin.url(url);
    }

    public LDAPServerList getUrls() {
        return this.urls;
    }

    protected Stream<IX509Certificate> ldapGetCertificates(IX509CertificateSelector selector, LDAPAddress url) throws IOException {
        CertStore certStore = this.getCertStore(url);
        try {
            return certStore.getCertificates(selector.toJavaSelector()).stream().filter(certificate -> certificate instanceof X509Certificate).map(X509Certificate.class::cast).map(CertificateTools::wrapJavaCert);
        }
        catch (CertStoreException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected Stream<IX509CRL> ldapGetCRLs(IX509CRLSelector selector, LDAPAddress url) throws IOException {
        CertStore certStore = this.getCertStore(url);
        try {
            return certStore.getCRLs(selector.toJavaSelector()).stream().filter(crl -> crl instanceof X509CRL).map(X509CRL.class::cast).map(CertificateTools::wrapJavaCRL).peek(CrlTools.attachProvider((ICRLProvider)this)).peek(crl -> {
                if (crl instanceof IAttributeSupport) {
                    ((IAttributeSupport)crl).setAttribute((Object)ATTR_URL, (Object)url.getUrl());
                }
            });
        }
        catch (CertStoreException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector selector = (IX509CertificateSelector)filter;
            if (selector.hasPrivateKey() != null && selector.hasPrivateKey().booleanValue()) {
                return Collections.emptyIterator();
            }
            IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
            if (serviceTypeSelector != null && serviceTypeSelector.isTrustedOnly()) {
                return Collections.emptyIterator();
            }
        }
        for (LDAPAddress address : this.urls.getURLs()) {
            Stream<IX509Certificate> certificates = null;
            if (filter instanceof IX509CertificateSelector) {
                try {
                    certificates = this.ldapGetCertificates((IX509CertificateSelector)filter, address);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (certificates == null) continue;
            return certificates.iterator();
        }
        return Collections.emptyIterator();
    }

    public Stream<IX509CRL> lookupCRLs(IX509CRLSelector selector, String url) throws IOException {
        for (LDAPAddress address : this.urls.getURLs()) {
            List crls = this.ldapGetCRLs(selector, address).collect(Collectors.toList());
            if (crls.isEmpty()) continue;
            return crls.stream();
        }
        return Stream.empty();
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
        if (this.dispatcher.isEmpty()) {
            this.dispatcher = null;
        }
    }

    protected void triggerChanged() {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"", null, null));
    }
}

