/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.x509download;

import de.intarsys.security.ldap.LDAPAddress;
import de.intarsys.tools.infoset.DocumentTools;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class LDAPServerList {
    private Map<String, LDAPAddress> entries = new TreeMap<String, LDAPAddress>();

    public Map<String, LDAPAddress> getEntries() {
        return new TreeMap<String, LDAPAddress>(this.entries);
    }

    public Collection<LDAPAddress> getURLs() {
        return this.entries.values();
    }

    public void restore(Reader output) throws IOException {
        IDocument doc = ElementFactory.get().parse(output);
        IElement root = doc.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            String baseDn;
            String port;
            IElement element = (IElement)i.next();
            LDAPAddress address = new LDAPAddress();
            String name = element.attributeValue("name", null);
            String host = element.attributeValue("host", null);
            if (host != null) {
                address.setHost(host);
            }
            if ((port = element.attributeValue("port", null)) != null) {
                address.setPort(Integer.parseInt(port));
            }
            if ((baseDn = element.attributeValue("baseDn", null)) != null) {
                address.setBaseDN(baseDn);
            }
            this.entries.put(name, address);
        }
    }

    public void setEntries(Map<String, LDAPAddress> entries) {
        this.entries.clear();
        this.entries.putAll(entries);
    }

    public void store(Writer output) throws IOException {
        IElementFactory factory = ElementFactory.get();
        IElement root = factory.createElement("ldapServers");
        IDocument doc = factory.createDocument();
        doc.setRootElement(root);
        for (Map.Entry<String, LDAPAddress> entry : this.entries.entrySet()) {
            String name = entry.getKey();
            LDAPAddress address = entry.getValue();
            IElement eAddress = root.newElementMapped("address");
            eAddress.setAttributeValue("name", name);
            if (address.getHost() != null) {
                eAddress.setAttributeValue("host", address.getHost());
            }
            eAddress.setAttributeValue("port", String.valueOf(address.getPort()));
            if (address.getBaseDN() == null) continue;
            eAddress.setAttributeValue("baseDn", address.getBaseDN());
        }
        DocumentTools.save((IDocument)doc, (Writer)output);
    }
}

