/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.x509download;

import de.intarsys.security.x509download.LDAPBasedX509Provider;
import de.intarsys.security.x509download.LDAPServerList;
import de.intarsys.security.x509download.PACKAGE;
import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.preferences.PreferencesTools;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

@Singleton
public class X509DownloadEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    private static X509DownloadEnvironment ACTIVE;
    private static final IMessageBundle Msg;
    public static final String PREF_DOWNLOAD_CERTIFICATES = "downloadCertificates";
    public static final String PREF_DOWNLOAD_CRLS = "downloadCRLs";
    public static final String PREF_LDAP_SERVERS = "ldapServers";
    public static final String PREF_STORE_DOWNLOADED_CERTIFICATES = "storeDownloadedCertificates";
    private IPreferences preferences;
    private boolean downloadCertificates;
    private boolean downloadCRLs;
    private LDAPServerList ldapServers = new LDAPServerList();
    private LDAPBasedX509Provider provider;
    private boolean storeDownloadedCertificates;

    public static X509DownloadEnvironment get() {
        return ACTIVE;
    }

    public X509DownloadEnvironment() {
        ACTIVE = this;
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public LDAPServerList getLDAPServerList() {
        return this.ldapServers;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "com.cabaret.prefs.security.common/x509download";
    }

    public synchronized LDAPBasedX509Provider getProvider() {
        if (this.provider == null) {
            this.provider = new LDAPBasedX509Provider(this.getLDAPServerList());
        }
        return this.provider;
    }

    @PostConstruct
    public void install() {
        this.preferencesRestore();
    }

    public boolean isDownloadCertificates() {
        return this.downloadCertificates;
    }

    public boolean isDownloadCRLs() {
        return this.downloadCRLs;
    }

    public boolean isStoreDownloadedCertificates() {
        return this.storeDownloadedCertificates;
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.putBoolean(PREF_DOWNLOAD_CERTIFICATES, false);
        preferences.putBoolean(PREF_STORE_DOWNLOADED_CERTIFICATES, false);
        preferences.putBoolean(PREF_DOWNLOAD_CRLS, false);
    }

    public void preferencesRestore() {
        IPreferences preferences = this.getPreferences();
        this.restoreLdapServers(preferences);
        this.downloadCertificates = preferences.getBoolean(PREF_DOWNLOAD_CERTIFICATES, false);
        this.storeDownloadedCertificates = preferences.getBoolean(PREF_STORE_DOWNLOADED_CERTIFICATES, false);
        this.downloadCRLs = preferences.getBoolean(PREF_DOWNLOAD_CRLS, false);
    }

    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
        this.storeLdapServers(preferences);
        preferences.putBoolean(PREF_DOWNLOAD_CERTIFICATES, this.isDownloadCertificates());
        preferences.putBoolean(PREF_STORE_DOWNLOADED_CERTIFICATES, this.isStoreDownloadedCertificates());
        preferences.putBoolean(PREF_DOWNLOAD_CRLS, this.isDownloadCRLs());
    }

    protected void restoreLdapServers(IPreferences preferences) {
        String definition = PreferencesTools.getLarge((IPreferences)preferences, (String)PREF_LDAP_SERVERS, null);
        if (definition == null) {
            return;
        }
        try {
            this.ldapServers.restore(new StringReader(definition));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDownloadCertificates(boolean downloadCertificates) {
        this.downloadCertificates = downloadCertificates;
    }

    public void setDownloadCRLs(boolean downloadCRLs) {
        this.downloadCRLs = downloadCRLs;
    }

    public void setStoreDownloadedCertificates(boolean storeDownloadedCertificates) {
        this.storeDownloadedCertificates = storeDownloadedCertificates;
    }

    protected void storeLdapServers(IPreferences preferences) {
        try {
            StringWriter w = new StringWriter();
            this.ldapServers.store(w);
            String definition = w.toString();
            PreferencesTools.putLarge((IPreferences)preferences, (String)PREF_LDAP_SERVERS, (String)definition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @PreDestroy
    public void uninstall() {
        this.preferencesStore();
    }

    static {
        Msg = PACKAGE.Messages;
    }
}

