/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.realm.JAASRealm;
import org.apache.tomcat.util.res.StringManager;

public class JAASCallbackHandler
implements CallbackHandler {
    protected static final StringManager sm = StringManager.getManager(JAASCallbackHandler.class);
    protected final String password;
    protected final JAASRealm realm;
    protected final String username;
    protected final String nonce;
    protected final String nc;
    protected final String cnonce;
    protected final String qop;
    protected final String realmName;
    protected final String digestA2;
    protected final String authMethod;
    protected final String algorithm;

    public JAASCallbackHandler(JAASRealm realm, String username, String password) {
        this(realm, username, password, null, null, null, null, null, null, null, null);
    }

    public JAASCallbackHandler(JAASRealm realm, String username, String password, String nonce, String nc, String cnonce, String qop, String realmName, String digestA2, String algorithm, String authMethod) {
        this.realm = realm;
        this.username = username;
        this.password = password != null && realm.hasMessageDigest(algorithm) ? realm.getCredentialHandler().mutate(password) : password;
        this.nonce = nonce;
        this.nc = nc;
        this.cnonce = cnonce;
        this.qop = qop;
        this.realmName = realmName;
        this.digestA2 = digestA2;
        this.authMethod = authMethod;
        this.algorithm = algorithm;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback2 : callbacks) {
            if (callback2 instanceof NameCallback) {
                if (this.realm.getContainer().getLogger().isTraceEnabled()) {
                    this.realm.getContainer().getLogger().trace(sm.getString("jaasCallback.username", this.username));
                }
                ((NameCallback)callback2).setName(this.username);
                continue;
            }
            if (callback2 instanceof PasswordCallback) {
                char[] passwordcontents = this.password != null ? this.password.toCharArray() : new char[]{};
                ((PasswordCallback)callback2).setPassword(passwordcontents);
                continue;
            }
            if (callback2 instanceof TextInputCallback) {
                TextInputCallback cb2 = (TextInputCallback)callback2;
                if (cb2.getPrompt().equals("nonce")) {
                    cb2.setText(this.nonce);
                    continue;
                }
                if (cb2.getPrompt().equals("nc")) {
                    cb2.setText(this.nc);
                    continue;
                }
                if (cb2.getPrompt().equals("cnonce")) {
                    cb2.setText(this.cnonce);
                    continue;
                }
                if (cb2.getPrompt().equals("qop")) {
                    cb2.setText(this.qop);
                    continue;
                }
                if (cb2.getPrompt().equals("realmName")) {
                    cb2.setText(this.realmName);
                    continue;
                }
                if (cb2.getPrompt().equals("digestA2")) {
                    cb2.setText(this.digestA2);
                    continue;
                }
                if (cb2.getPrompt().equals("authMethod")) {
                    cb2.setText(this.authMethod);
                    continue;
                }
                if (cb2.getPrompt().equals("algorithm")) {
                    cb2.setText(this.algorithm);
                    continue;
                }
                if (cb2.getPrompt().equals("catalinaBase")) {
                    cb2.setText(this.realm.getContainer().getCatalinaBase().getAbsolutePath());
                    continue;
                }
                throw new UnsupportedCallbackException(callback2);
            }
            throw new UnsupportedCallbackException(callback2);
        }
    }
}

