/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.upreg;

import de.intarsys.cwt.awt.image.ImageIOImageContainer;
import de.intarsys.cwt.awt.image.ImageIOImageEntry;
import de.intarsys.cwt.image.IImage;
import de.intarsys.document.model.IDocument;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSTools;
import de.intarsys.pdf.design.shape.Image;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.SignerTools;
import de.intarsys.security.device.upreg.ParameterizedUPRegSigner;
import de.intarsys.security.device.upreg.UPRegSigner;
import de.intarsys.security.device.upreg.client.Layout;
import de.intarsys.security.device.upreg.client.PageKey;
import de.intarsys.security.device.upreg.client.Rt1GenerateResponse;
import de.intarsys.security.digest.DigestTools;
import de.intarsys.security.document.type.pdf.signature.ISignatureDecorator;
import de.intarsys.security.document.type.pdf.signature.PDFDocumentSigner;
import de.intarsys.security.document.type.pdf.signature.PDFDocumentSignerFactory;
import de.intarsys.security.document.type.pdf.signature.shape.ShapeDecoratorFactory;
import de.intarsys.security.document.upreg.InvalidDocumentException;
import de.intarsys.security.document.upreg.PACKAGE;
import de.intarsys.security.method.pdf.common.PDFAdditionalInfoSet;
import de.intarsys.security.method.pdf.signature.DSFactoryPAdESEnhanced;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureEntry;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.method.pdf.xmp.GenericXMPMetadata;
import de.intarsys.security.method.pdf.xmp.MetadataTools;
import de.intarsys.security.processor.signature.CommonDocumentSigner;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.security.processor.signature.SignatureLocatorCreationStrategy;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.enumeration.common.EnumResize;
import de.intarsys.tools.enumeration.common.IAlignment;
import de.intarsys.tools.enumeration.common.IResize;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class UPRegDocumentSigner
extends CommonDocumentSigner {
    private static final double IMAGE_DPI_SCALE = 0.24;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public UPRegDocumentSigner(IFactory factory, IDocument document) {
        super(factory, document);
    }

    protected Collection<String> getSupportedHashAlgorithmNames() {
        return UPRegSigner.SUPPORTED_HASH_ALGORITHM_NAMES;
    }

    protected IConversation<ISignatureContainer> basicSign(IDigester digester) {
        PDDocument pdDocument = this.getPDDocument();
        try {
            if (this.getPdfaPart(pdDocument) < 1) {
                throw new InvalidDocumentException(PACKAGE.Messages.getString("UPRegDocumentSigner.documentNotPdfaCompliant", new Object[]{this.getDocumentName()}));
            }
            PDFSignatureEntry lastSignatureEntry = this.getLastSignatureEntry(pdDocument);
            byte[] encodedSignature = this.getEncodedSignature(lastSignatureEntry);
            IDigest signedDigest = this.getSignedDigest(pdDocument, lastSignatureEntry);
            int signedRevision = this.getSignedRevision(lastSignatureEntry);
            ParameterizedUPRegSigner digestSigner = this.createDigestSigner(encodedSignature, signedDigest, signedRevision);
            return digestSigner.whenAuthorized().thenApply(generateResponse -> this.createDocumentSigner(pdDocument, digester, (ISigner)digestSigner, (Rt1GenerateResponse)generateResponse)).thenCompose(CommonDocumentSigner::getConversation);
        }
        catch (DocumentSignerException exception) {
            return Conversation.failed((Throwable)exception);
        }
    }

    private PDFSignatureEntry getLastSignatureEntry(PDDocument document) throws DocumentSignerException {
        return PDFSignatureContainer.createSignatureContainer((PDDocument)document).getEntries().stream().filter(PDFSignatureEntry.class::isInstance).reduce((current, next) -> next).map(PDFSignatureEntry.class::cast).orElseThrow(() -> new InvalidDocumentException(PACKAGE.Messages.getString("UPRegDocumentSigner.documentNotSigned", new Object[]{this.getDocumentName()})));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private IDigest getSignedDigest(PDDocument pdDocument, PDFSignatureEntry signatureEntry) throws DocumentSignerException {
        PDSignature signature = signatureEntry.getPDSignature();
        COSArray cosByteRange = signature.cosGetByteRange();
        if (cosByteRange == null) {
            throw new InvalidDocumentException(PACKAGE.Messages.getString("UPRegDocumentSigner.missingByteRangeInSignature", new Object[]{this.getDocumentName()}));
        }
        DigestAlgorithm digestAlgorithm = this.getDigestAlgorithm(signatureEntry);
        if (digestAlgorithm == null) {
            throw new InvalidDocumentException(PACKAGE.Messages.getString("UPRegDocumentSigner.signatureWithUnspecifiedHashAlgorithm", new Object[]{this.getDocumentName()}));
        }
        try (IRandomAccess randomAccess = pdDocument.getLocator().getRandomAccess();){
            IDigest iDigest;
            try (PDSignatureByteRange input = new PDSignatureByteRange(cosByteRange, randomAccess);){
                IDigester digester = DigestTools.getDigester((Object)digestAlgorithm);
                digester.digestUpdate((InputStream)input);
                iDigest = digester.digestFinal();
            }
            return iDigest;
        }
        catch (IOException exception) {
            throw new InvalidDocumentException(PACKAGE.Messages.getString("UPRegDocumentSigner.failedToExtractSignedHash", new Object[]{this.getDocumentName()}), exception);
        }
    }

    private DigestAlgorithm getDigestAlgorithm(PDFSignatureEntry signatureEntry) {
        AlgorithmSpec algorithmSpec = signatureEntry.getHashAlgorithmSpec();
        return algorithmSpec == null ? null : (DigestAlgorithm)algorithmSpec.getAlgorithm();
    }

    private int getSignedRevision(PDFSignatureEntry signatureEntry) throws InvalidDocumentException {
        List revisions;
        COSObject cosSignature = signatureEntry.getPDSignature().cosGetObject();
        try {
            revisions = COSTools.getRevisions((COSDocument)cosSignature.getDoc());
        }
        catch (COSLoadException | IOException exception) {
            throw new InvalidDocumentException(PACKAGE.Messages.getString("UPRegDocumentSigner.failedToIdentifySignedRevision", new Object[]{this.getDocumentName()}), exception);
        }
        int objectNumber = cosSignature.getIndirectObject().getKey().getObjectNumber();
        for (int i = revisions.size() - 1; i >= 0; --i) {
            if (!((COSTools.IRevision)revisions.get(i)).definesObject(objectNumber)) continue;
            return i + 1;
        }
        throw new InvalidDocumentException(PACKAGE.Messages.getString("UPRegDocumentSigner.unknownSignedRevision", new Object[]{this.getDocumentName()}));
    }

    private byte[] getEncodedSignature(PDFSignatureEntry signatureEntry) {
        return signatureEntry.getPDSignature().getContentBytes();
    }

    private ParameterizedUPRegSigner createDigestSigner(byte[] lastSignature, IDigest signedDigest, int signedRevision) throws DocumentSignerException {
        ISigner signer;
        try {
            signer = SignerTools.getSigner((IArgs)this.getArgs(), (String)"digestSigner");
        }
        catch (ObjectCreationException exception) {
            throw new DocumentSignerException("Invalid digest signer", (Throwable)exception);
        }
        UPRegSigner batchSigner = (UPRegSigner)AdapterTools.getAdapter((Object)signer, UPRegSigner.class, null);
        if (batchSigner == null) {
            throw new DocumentSignerException("Unsupported digest signer; need a UPRegSigner");
        }
        return batchSigner.createChild(this.getDocumentName(), lastSignature, signedDigest, signedRevision);
    }

    private PDFDocumentSigner createDocumentSigner(PDDocument pdDocument, IDigester digester, ISigner digestSigner, Rt1GenerateResponse generateResponse) throws ObjectCreationException, DocumentSignerException {
        Layout layout = generateResponse.getLayout();
        PDPage page = this.selectPage(pdDocument, layout.getPage());
        if (page == null) {
            throw new DocumentSignerException(PACKAGE.Messages.getString("UPRegDocumentSigner.missingRequestedPage", new Object[]{this.getDocumentName(), layout.getPage()}));
        }
        IImage image = this.createImage(generateResponse.getImage());
        if (image.getWidth() <= 0 || image.getHeight() <= 0) {
            throw new DocumentSignerException(PACKAGE.Messages.getString("UPRegDocumentSigner.invalidImageSize", new Object[0]));
        }
        IArgs fieldDefinition = this.computeFieldDefinition(page, layout.getLeft(), layout.getTop(), image.getWidth(), image.getHeight());
        ISignatureDecorator decorator = this.createSignatureDecorator(image);
        PDFAdditionalInfoSet additionalInfoSet = new PDFAdditionalInfoSet();
        additionalInfoSet.setValue("Reason", generateResponse.getSignatureReason());
        Args signerArgs = Args.createNamed((Object[])new Object[]{"document", pdDocument, "locator", this.getArgs().get("locator"), "digester", digester, "digestSigner", digestSigner, "additionalInfoSet", additionalInfoSet, "format", DSFactoryPAdESEnhanced.get(), "field", fieldDefinition, "decorator", decorator});
        return (PDFDocumentSigner)new PDFDocumentSignerFactory().createInstance((IArgs)signerArgs);
    }

    private PDPage selectPage(PDDocument pdDocument, PageKey key) {
        PDPageTree pageTree = pdDocument.getPageTree();
        return switch (key) {
            default -> throw new IncompatibleClassChangeError();
            case PageKey.FIRST -> pageTree.getFirstPage();
            case PageKey.ULTIMATE -> pageTree.getLastPage();
            case PageKey.PENULTIMATE -> {
                PDPage secondLastPage;
                PDPage lastPage = pageTree.getLastPage();
                if (lastPage != null && (secondLastPage = lastPage.getPreviousPage()) != null) {
                    yield secondLastPage;
                }
                yield lastPage;
            }
        };
    }

    private IImage createImage(byte[] data) throws DocumentSignerException {
        ImageIOImageEntry imageIOImageEntry;
        block8: {
            ByteArrayLocator locator = new ByteArrayLocator(data, "imageData");
            ImageIOImageContainer container = ImageIOImageContainer.createFromLocator((ILocator)locator);
            try {
                imageIOImageEntry = container.getImageAt(0);
                if (container == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (container != null) {
                        try {
                            container.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalArgumentException exception) {
                    throw new DocumentSignerException(PACKAGE.Messages.getString("UPRegDocumentSigner.malformedImageData", new Object[0]), (Throwable)exception);
                }
            }
            container.close();
        }
        return imageIOImageEntry;
    }

    private IArgs computeFieldDefinition(PDPage page, int x, int y, int preferredWidth, int preferredHeight) {
        CDSRectangle mediaBox = page.getMediaBox().normalize();
        double left = Math.max((float)x, mediaBox.getLowerLeftX());
        double top = Math.min((float)y, mediaBox.getUpperRightY());
        double width = Math.min((double)preferredWidth * 0.24, (double)mediaBox.getUpperRightX() - left);
        double height = Math.min((double)preferredHeight * 0.24, top - (double)mediaBox.getLowerLeftY());
        if (width < (double)preferredWidth || height < (double)preferredHeight) {
            double scaleX = width / (double)preferredWidth;
            double scaleY = height / (double)preferredHeight;
            if (scaleX < scaleY) {
                height = (double)preferredHeight * scaleX;
            } else {
                width = (double)preferredWidth * scaleY;
            }
        }
        int pageIndex = page.getNodeIndex();
        return Args.createNamed((Object[])new Object[]{"x", left, "y", top, "width", width, "height", height, "pageRange", pageIndex});
    }

    private ISignatureDecorator createSignatureDecorator(IImage image) throws DocumentSignerException {
        RectAlignment alignment = new RectAlignment();
        alignment.setHorizontalAlignment((IAlignment)EnumAlignment.START);
        alignment.setHorizontalResize((IResize)EnumResize.FILL);
        alignment.setVerticalAlignment((IAlignment)EnumAlignment.START);
        alignment.setVerticalResize((IResize)EnumResize.FILL);
        alignment.setProportional(false);
        Image shape = Image.create(null);
        shape.setAlignment(alignment);
        shape.setImage(image);
        Args decoratorArgs = Args.createNamed((Object[])new Object[]{"shapes", List.of(shape)});
        try {
            return (ISignatureDecorator)FactoryTools.createInstance(ShapeDecoratorFactory.class, (IArgs)decoratorArgs);
        }
        catch (ObjectCreationException exception) {
            throw new DocumentSignerException("Signature creation failed", (Throwable)exception);
        }
    }

    private PDDocument getPDDocument() {
        return (PDDocument)this.getDocument().getImpl();
    }

    private String getDocumentName() {
        IDocument document = this.getDocument();
        String shortName = document.getShortName();
        if (shortName != null && !shortName.isEmpty()) {
            return shortName;
        }
        String longName = document.getLongName();
        if (longName != null && !longName.isEmpty()) {
            return longName;
        }
        return "<unnamed>";
    }

    private int getPdfaPart(PDDocument pdDocument) {
        try {
            Integer part;
            Document metadata = MetadataTools.getMetadataAsDocument((COSBasedObject)pdDocument.getCatalog());
            GenericXMPMetadata xmp = GenericXMPMetadata.from((Document)metadata).withPdfaSchemas().build();
            XMPSchemaPDFAId pdfaId = (XMPSchemaPDFAId)xmp.getSchema(XMPSchemaPDFAId.class);
            if (pdfaId != null && (part = pdfaId.getPart()) != null) {
                return part;
            }
        }
        catch (IOException | NumberFormatException exception) {
            this.logger.debug("Failed to obtain PDF/A ID", (Throwable)exception);
        }
        return 0;
    }

    protected String getSignedDocManipulationMessage() {
        return PACKAGE.Messages.getString("UPRegDocumentSigner.documentWasManipulated", new Object[]{this.getDocumentName()});
    }

    protected SignatureLocatorCreationStrategy getLocatorCreationStrategy() {
        throw new UnsupportedOperationException("not used in this implementation");
    }
}

