/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.library.core;

import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.library.core.ICertificateLibrary;
import de.intarsys.security.certstore.node.CommonCertStoreContainerNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.security.certstore.node.IMutableCertStoreContainerNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateLibraryNode
extends CommonCertStoreContainerNode
implements IMutableCertStoreContainerNode {
    private static final Logger Log = LoggerFactory.getLogger(CertificateLibraryNode.class);
    private final ICertificateLibrary certificateLibrary;
    private List<ICertStoreNode> children;

    protected CertificateLibraryNode(ICertificateLibrary certificateLibrary) {
        super(null);
        this.certificateLibrary = certificateLibrary;
    }

    @Override
    public void addChild(ICertStoreNode node) {
        this.getCustomCertStoreContainerNode().addChild(node);
        this.basicRefresh();
    }

    @Override
    public void addChild(ICertStoreNode node, int index) {
        this.getCustomCertStoreContainerNode().addChild(node, index);
        this.basicRefresh();
    }

    @Override
    protected synchronized List<ICertStoreNode> basicGetChildren() {
        if (this.children == null) {
            this.children = this.collectNodes();
        }
        return this.children;
    }

    protected void basicRefresh() {
        this.children = null;
    }

    protected List<ICertStoreNode> collectNodes() {
        ArrayList<ICertStoreNode> result = new ArrayList<ICertStoreNode>();
        for (ICertStoreNodeProvider provider : this.getCertificateLibrary().getCertStoreNodeProviders()) {
            List<ICertStoreNode> nodes = provider.getCertStoreNode().getChildren();
            for (ICertStoreNode node : nodes) {
                node.setParent(this);
                result.add(node);
            }
        }
        return result;
    }

    public ICertificateLibrary getCertificateLibrary() {
        return this.certificateLibrary;
    }

    public IMutableCertStoreContainerNode getCustomCertStoreContainerNode() {
        for (ICertStoreNode node : this.children) {
            if (!(node instanceof IMutableCertStoreContainerNode)) continue;
            return (IMutableCertStoreContainerNode)node;
        }
        throw new IllegalStateException("no custom container");
    }

    @Override
    public void refresh() {
        this.basicRefresh();
        super.refresh();
    }

    @Override
    public void removeChild(ICertStoreNode node) {
        this.getCustomCertStoreContainerNode().removeChild(node);
        this.basicRefresh();
    }

    @Override
    public void sort(Comparator<ICertStoreNode> comparator) {
        this.getCustomCertStoreContainerNode().sort(comparator);
        this.basicRefresh();
    }
}

