/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.library.root;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.AllCertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.trustrepository.TrustRepository;
import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.library.root.PACKAGE;
import de.intarsys.security.certstore.node.CommonCertStoreContainerNode;
import de.intarsys.security.certstore.node.DefaultCertificateNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RootCertificateContainerNode
extends CommonCertStoreContainerNode {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private List<ICertStoreNode> nodes;

    public RootCertificateContainerNode(ICertStoreNodeProvider nodeProvider) {
        super(nodeProvider, true);
        this.setName(Msg.getString("CertificateStoreInstrument.LabelTrustedRootCertificates", new Object[0]));
    }

    public RootCertificateContainerNode(ICertStoreNodeProvider nodeProvider, boolean immutable) {
        super(nodeProvider, immutable);
    }

    @Override
    protected List<ICertStoreNode> basicGetChildren() {
        if (this.nodes == null) {
            this.nodes = this.createNodes();
        }
        return this.nodes;
    }

    protected List<ICertStoreNode> createNodes() {
        ArrayList<ICertStoreNode> result = new ArrayList<ICertStoreNode>();
        ICertificateProvider rootCertificates = TrustRepository.get().getRootCertificates();
        if (rootCertificates != null) {
            Iterator i = rootCertificates.lookupCertificates((IX509CertificateFilter)AllCertificateFilter.UNIQUE);
            while (i.hasNext()) {
                IX509Certificate certificate = (IX509Certificate)i.next();
                DefaultCertificateNode node = new DefaultCertificateNode(this.getNodeProvider(), certificate);
                node.setImmutable(true);
                node.setTrusted(true);
                node.setParent(this);
                result.add(node);
            }
        }
        return result;
    }
}

