/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.node;

import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.node.ICertStoreContainerNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.security.certstore.node.IMutableCertStoreContainerNode;

public abstract class CertStoreNodeBase
implements ICertStoreNode {
    private ICertStoreContainerNode parent;
    private final ICertStoreNodeProvider nodeProvider;
    private boolean immutable = false;
    private String name;

    protected CertStoreNodeBase(ICertStoreNodeProvider factory) {
        this.nodeProvider = factory;
    }

    protected CertStoreNodeBase(ICertStoreNodeProvider factory, boolean immutable) {
        this.setImmutable(immutable);
        this.nodeProvider = factory;
    }

    @Override
    public void dispose() {
        if (this.getParent() instanceof IMutableCertStoreContainerNode) {
            ((IMutableCertStoreContainerNode)this.getParent()).removeChild(this);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertStoreNodeBase)) {
            return false;
        }
        CertStoreNodeBase other = (CertStoreNodeBase)obj;
        if (!this.safeEquals(this.getName(), other.getName())) {
            return false;
        }
        if (this.isImmutable() != other.isImmutable()) {
            return false;
        }
        return this.safeEquals(this.getParent(), other.getParent());
    }

    public String getDescription() {
        return this.getName();
    }

    @Override
    public ICertStoreNodeProvider getNodeProvider() {
        return this.nodeProvider;
    }

    public String getIconName() {
        return null;
    }

    @Override
    public String getId() {
        return this.getClass().getName() + " [" + this.getName() + "]";
    }

    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ICertStoreContainerNode getParent() {
        return this.parent;
    }

    public String getTip() {
        return this.getName();
    }

    @Override
    public boolean isImmutable() {
        boolean result = this.immutable;
        if (this.getParent() != null) {
            result = result || this.getParent().isImmutable();
        }
        return result;
    }

    @Override
    public void refresh() {
    }

    protected boolean safeEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParent(ICertStoreContainerNode node) {
        this.parent = node;
    }
}

