/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.node;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certstore.node.ICertStoreCertificateNode;
import de.intarsys.security.certstore.node.ICertStoreContainerNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.security.certstore.node.ICertStoreNodeFilter;
import de.intarsys.security.virtualkeystore.core.ICertificateSupport;
import de.intarsys.security.virtualkeystore.core.IPrivateKeySupport;
import de.intarsys.tools.adapter.AdapterTools;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertStoreNodeTools {
    public static final int NODETYPE_ANYCERTIFICATE = 14;
    public static final int NODETYPE_KEY = 2;

    public static ICertStoreNode findNode(ICertStoreNode root, ICertStoreNodeFilter filter) {
        if (filter.accept(root)) {
            return root;
        }
        if (root instanceof ICertStoreContainerNode) {
            for (ICertStoreNode child : ((ICertStoreContainerNode)root).getChildren()) {
                ICertStoreNode result = CertStoreNodeTools.findNode(child, filter);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static ICertStoreNode findNode(ICertStoreNode root, IX509Certificate certificate) {
        return CertStoreNodeTools.findNode(root, certificate, 14);
    }

    public static ICertStoreNode findNode(ICertStoreNode root, IX509Certificate certificate, boolean keyOnly) {
        int type = 0;
        type = keyOnly ? 2 : 14;
        return CertStoreNodeTools.findNode(root, certificate, type);
    }

    public static ICertStoreNode findNode(ICertStoreNode root, final IX509Certificate certificate, final int type) {
        return CertStoreNodeTools.findNode(root, new ICertStoreNodeFilter(){

            @Override
            public boolean accept(ICertStoreNode node) {
                ICertStoreCertificateNode certificateNode;
                if (node instanceof ICertStoreCertificateNode && ((certificateNode = (ICertStoreCertificateNode)node).getType() & type) != 0) {
                    try {
                        IX509Certificate currentCertificate = certificateNode.getCertificate();
                        if (certificate.equals(currentCertificate)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        });
    }

    public static ICertStoreNode findNode(ICertStoreNode root, final String id) {
        return CertStoreNodeTools.findNode(root, new ICertStoreNodeFilter(){

            @Override
            public boolean accept(ICertStoreNode node) {
                return id.equals(node.getId());
            }
        });
    }

    public static Set<IX509Certificate> getCertificates(ICertStoreNode node) {
        HashSet<IX509Certificate> result = new HashSet<IX509Certificate>();
        if (node instanceof ICertStoreCertificateNode) {
            try {
                IX509Certificate currentCertificate = ((ICertStoreCertificateNode)node).getCertificate();
                result.add(currentCertificate);
            }
            catch (Exception currentCertificate) {
                // empty catch block
            }
        }
        if (node instanceof ICertStoreContainerNode) {
            for (ICertStoreNode child : ((ICertStoreContainerNode)node).getChildren()) {
                result.addAll(CertStoreNodeTools.getCertificates(child));
            }
        }
        return result;
    }

    public static ICertificateSupport getCertificateSupport(ICertStoreNode node) {
        return (ICertificateSupport)AdapterTools.getAdapter((Object)node, ICertificateSupport.class, null);
    }

    public static IPrivateKeySupport getPrivateKeySupport(ICertStoreNode node) {
        return (IPrivateKeySupport)AdapterTools.getAdapter((Object)node, IPrivateKeySupport.class, null);
    }

    public static void sort(List<ICertStoreNode> nodes) {
        Collections.sort(nodes, new Comparator<ICertStoreNode>(){

            @Override
            public int compare(ICertStoreNode n1, ICertStoreNode n2) {
                String l2;
                String l1 = n1.getLabel();
                if (l1 == null) {
                    l1 = "";
                }
                if ((l2 = n2.getLabel()) == null) {
                    l2 = "";
                }
                return l1.compareTo(l2);
            }
        });
    }
}

