/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.node;

import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.node.CertStoreNodeBase;
import de.intarsys.security.certstore.node.ICertStoreContainerNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.tools.streaming.StreamingTools;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CommonCertStoreContainerNode
extends CertStoreNodeBase
implements ICertStoreContainerNode {
    private static final Logger Log = LoggerFactory.getLogger(CommonCertStoreContainerNode.class);

    protected CommonCertStoreContainerNode(ICertStoreNodeProvider nodeProvider) {
        super(nodeProvider);
    }

    protected CommonCertStoreContainerNode(ICertStoreNodeProvider nodeProvider, boolean immutable) {
        super(nodeProvider, immutable);
    }

    protected abstract List<ICertStoreNode> basicGetChildren();

    @Override
    public void dispose() {
        StreamingTools.copyStream(this.basicGetChildren()).forEach(ICertStoreNode::dispose);
        super.dispose();
    }

    @Override
    public ICertStoreNode get(String path) {
        List<ICertStoreNode> children = this.basicGetChildren();
        if (children == null || path == null) {
            return null;
        }
        ICertStoreNode baseNode = null;
        String basePath = null;
        if (path.startsWith("/")) {
            baseNode = this.getRoot();
            basePath = path.substring(1);
        } else {
            int separatorIndex = path.indexOf(47);
            String baseName = null;
            if (separatorIndex < 0) {
                baseName = path;
            } else {
                baseName = path.substring(0, separatorIndex);
                basePath = path.substring(separatorIndex + 1);
            }
            baseNode = this.getChild(baseName);
        }
        if (baseNode instanceof ICertStoreContainerNode && !StringTools.isEmpty((String)basePath)) {
            return baseNode.get(basePath);
        }
        return baseNode;
    }

    @Override
    public ICertStoreNode getChild(String name) {
        for (ICertStoreNode child : this.basicGetChildren()) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    @Override
    public List<ICertStoreNode> getChildren() {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("fetching children of node {}", (Object)this.getName());
        }
        return new ArrayList<ICertStoreNode>(this.basicGetChildren());
    }

    @Override
    public String getIconName() {
        return "icons/folder";
    }

    @Override
    public int getIndex(ICertStoreNode node) {
        return this.basicGetChildren().indexOf(node);
    }

    protected ICertStoreContainerNode getRoot() {
        ICertStoreContainerNode current = this;
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current;
    }

    @Override
    public void refresh() {
        for (ICertStoreNode child : this.basicGetChildren()) {
            child.refresh();
        }
    }

    @Override
    public int size() {
        return this.basicGetChildren().size();
    }
}

