/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.node;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.node.BasicX509CertificateNode;

public class DefaultCertificateNode
extends BasicX509CertificateNode {
    private static final String ICON_CERT = "icons/certificate";
    private static final String ICON_CERT_TRUSTED = "icons/certificate_trusted";
    private static final String ICON_KEY = "icons/key";
    private static final String ICON_KEY_TRUSTED = "icons/key_trusted";
    private final IX509Certificate certificate;
    private boolean trusted;
    private boolean key;

    public DefaultCertificateNode(ICertStoreNodeProvider nodeProvider, IX509Certificate certificate) {
        super(nodeProvider, true);
        this.certificate = certificate;
        this.setName(CertificateTools.getSubjectLabel((IX509Certificate)certificate));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof DefaultCertificateNode)) {
            return false;
        }
        DefaultCertificateNode other = (DefaultCertificateNode)obj;
        if (this.isKey() != other.isKey()) {
            return false;
        }
        if (this.isTrusted() != other.isTrusted()) {
            return false;
        }
        return this.safeEquals(this.getCertificate(), other.getCertificate());
    }

    @Override
    public IX509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public String getIconName() {
        if (this.isKey()) {
            return this.isTrusted() ? ICON_KEY_TRUSTED : ICON_KEY;
        }
        IX509Certificate cert = this.getCertificate();
        if (cert == null) {
            return "icons/error";
        }
        if (cert instanceof IX509AttributeCertificate) {
            if (this.isTrusted()) {
                return "icons/attrcert_trusted";
            }
            return "icons/attrcert";
        }
        if (this.isTrusted()) {
            return ICON_CERT_TRUSTED;
        }
        return ICON_CERT;
    }

    @Override
    public int getType() {
        if (this.isKey()) {
            return 2;
        }
        if (this.certificate instanceof IX509AttributeCertificate) {
            return 8;
        }
        if (this.certificate instanceof IX509PublicKeyCertificate) {
            return 4;
        }
        return 1;
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }
}

