/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.node;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.node.BasicX509CertificateNode;
import de.intarsys.security.certstore.node.SynchedCertStoreContainerNode;
import de.intarsys.security.virtualkeystore.core.IPrivateKeySupport;
import de.intarsys.tools.crypto.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

public class DynamicCertificateNode<A>
extends BasicX509CertificateNode
implements IPrivateKeySupport {
    private static final String ICON_CERT = "icons/certificate";
    private static final String ICON_CERT_TRUSTED = "icons/certificate_trusted";
    private static final String ICON_KEY = "icons/key";
    private static final String ICON_KEY_TRUSTED = "icons/key_trusted";
    private A alias;
    private IX509Certificate certificate;
    private SynchedCertStoreContainerNode group;

    public DynamicCertificateNode(ICertStoreNodeProvider nodeProvider, SynchedCertStoreContainerNode group, A alias) {
        super(nodeProvider);
        this.group = group;
        this.alias = alias;
        this.setParent(group);
    }

    public boolean canExportKey() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof DynamicCertificateNode)) {
            return false;
        }
        DynamicCertificateNode other = (DynamicCertificateNode)obj;
        if (!this.safeEquals(this.getAlias(), other.getAlias())) {
            return false;
        }
        if (!this.safeEquals(this.getGroup(), other.getGroup())) {
            return false;
        }
        return this.safeEquals(this.getCertificate(), other.getCertificate());
    }

    public A getAlias() {
        return this.alias;
    }

    @Override
    public IX509Certificate getCertificate() {
        if (this.certificate == null) {
            this.certificate = this.getGroup().getCertificate(this.getAlias());
        }
        return this.certificate;
    }

    public SynchedCertStoreContainerNode getGroup() {
        return this.group;
    }

    @Override
    public String getIconName() {
        if (this.isKeyEntry()) {
            return this.isTrusted() ? ICON_KEY_TRUSTED : ICON_KEY;
        }
        return this.isTrusted() ? ICON_CERT_TRUSTED : ICON_CERT;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = CertificateTools.getSubjectLabel((IX509Certificate)this.getCertificate());
            this.setName(name);
        }
        return name;
    }

    public PrivateKey getPrivateKey(Secret password) throws IOException, GeneralSecurityException {
        return this.getGroup().getPrivateKey(this.getAlias(), password);
    }

    @Override
    public int getType() {
        if (this.isKeyEntry()) {
            return 2;
        }
        if (this.getCertificate() instanceof IX509AttributeCertificate) {
            return 8;
        }
        if (this.getCertificate() instanceof IX509PublicKeyCertificate) {
            return 4;
        }
        return 1;
    }

    @Override
    public boolean isImmutable() {
        return this.getGroup().isImmutable();
    }

    protected boolean isKeyEntry() {
        return this.getGroup().isKeyEntry(this.getAlias());
    }

    public boolean isTrusted() {
        return this.getGroup().isTrusted(this.getAlias());
    }

    public void setTrusted(boolean trusted) {
    }
}

