/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.node;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.node.CommonCertStoreContainerNode;
import de.intarsys.security.certstore.node.DynamicCertificateNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.crypto.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SynchedCertStoreContainerNode<A>
extends CommonCertStoreContainerNode {
    private static final Logger Log = LoggerFactory.getLogger(SynchedCertStoreContainerNode.class);
    private final List<ICertStoreNode> children = new ArrayList<ICertStoreNode>();

    protected SynchedCertStoreContainerNode(ICertStoreNodeProvider nodeProvider) {
        super(nodeProvider, true);
        this.customizeNode();
    }

    protected abstract Iterator<A> aliases();

    @Override
    protected List<ICertStoreNode> basicGetChildren() {
        this.synchChildren(this.children);
        return this.children;
    }

    protected void customizeNode() {
    }

    protected abstract IX509Certificate getCertificate(A var1);

    protected abstract PrivateKey getPrivateKey(A var1, Secret var2) throws IOException, GeneralSecurityException;

    protected abstract boolean isKeyEntry(A var1);

    protected abstract boolean isTrusted(A var1);

    @Override
    public void refresh() {
        this.children.clear();
        super.refresh();
    }

    protected void synchChildren(List<ICertStoreNode> children) {
        HashSet currentAliases = new HashSet(ListTools.toList(this.aliases()));
        HashSet storedAliases = new HashSet();
        Iterator<ICertStoreNode> i = children.iterator();
        while (i.hasNext()) {
            DynamicCertificateNode child = (DynamicCertificateNode)i.next();
            Object alias = child.getAlias();
            if (!currentAliases.contains(alias)) {
                i.remove();
                continue;
            }
            storedAliases.add(alias);
        }
        for (Object alias : currentAliases) {
            if (storedAliases.contains(alias)) continue;
            DynamicCertificateNode child = new DynamicCertificateNode(this.getNodeProvider(), this, alias);
            children.add(child);
        }
    }
}

