/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.ec;

import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.algorithm.ec.EcTools;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;

public class EcdsaTools {
    public static byte[] encodeDerSigValue(byte[] message, PublicKey publicKey) {
        int keyPairSize = EcTools.getKeyByteSize(publicKey) * 2;
        if (message.length <= keyPairSize) {
            int pointSize = message.length / 2;
            byte[] part = new byte[pointSize + 1];
            System.arraycopy(message, 0, part, 1, pointSize);
            BigInteger r = new BigInteger(part);
            System.arraycopy(message, pointSize, part, 1, pointSize);
            BigInteger s = new BigInteger(part);
            ASN1SequenceHolder seq = new ASN1SequenceHolder();
            seq.addChild((ASN1Encodable)new ASN1Integer(r));
            seq.addChild((ASN1Encodable)new ASN1Integer(s));
            try {
                return ASN1Tools.toByteArray((ASN1Encodable[])new ASN1Encodable[]{seq});
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage(), e);
            }
        }
        return message;
    }

    public static int getExpectedSignatureSize(PublicKey publicKey) {
        return EcTools.getKeyByteSize(publicKey) * 2 + 6;
    }

    private static byte[] getMessage(byte[] originalMessage) {
        try {
            IDigest digest = DigestTools.decode((byte[])originalMessage);
            return digest.getBytes();
        }
        catch (Exception e) {
            return originalMessage;
        }
    }

    public static boolean validate(byte[] signature, PublicKey publicKey, AlgorithmParameterSpec params, byte[] message) throws GeneralSecurityException {
        byte[] bytes = EcdsaTools.getMessage(message);
        Signature jcaSignature = Signature.getInstance("NONEwithECDSA", "BC");
        jcaSignature.initVerify(publicKey);
        jcaSignature.update(bytes);
        byte[] derSigValue = EcdsaTools.encodeDerSigValue(signature, publicKey);
        return jcaSignature.verify(derSigValue);
    }

    private EcdsaTools() {
    }
}

