/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.validation.IDigestProvider;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class StaticDigestProvider
implements IDigestProvider {
    private final IDigest digest;
    private final DigestAlgorithm digestAlgorithm;

    public StaticDigestProvider(IDigest digest) {
        this.digest = digest;
        this.digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical(this.getDigest().getAlgorithmName());
    }

    public IDigest getDigest() {
        return this.digest;
    }

    @Override
    public IDigest getDigest(AlgorithmSpec algorithmSpec) throws NoSuchAlgorithmException, IOException {
        if (algorithmSpec == null) {
            throw new IOException("no digest algorithm specified");
        }
        if (!this.digestAlgorithm.getCanonicalName().equals(((Algorithm)algorithmSpec.getAlgorithm()).getCanonicalName())) {
            return null;
        }
        return this.getDigest();
    }
}

