/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation;

import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.EnumValidityModel;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.certificate.common.CollectionCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.date.DateEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class ValidationParameters
implements IValidationParameters {
    private ICertificateProvider additionalCerts;
    private ICertificateProvider trustedCerts;
    private Date dateToTest;
    private boolean confirmedDate;
    private EnumValidityModel validityModel;
    private EnumKeyPurpose keyPurpose;
    private Set<String> initialPolicies;
    private ICRLProvider crlProvider;
    private IExtendedValidationData extendedValidationData;
    private int depth = 0;
    private boolean dateSet;
    private final AttributeMap attributes = new AttributeMap();

    public static ValidationParameters copy(IValidationParameters params) {
        ValidationParameters copy = new ValidationParameters();
        copy.setAdditionalCerts(params.getAdditionalCerts());
        copy.setTrustedCerts(params.getTrustedCerts());
        if (params.basicGetDateToTest() != null) {
            copy.setDateToTest((Date)params.basicGetDateToTest().clone(), params.isConfirmedDate());
        }
        copy.setInitialPolicies(new HashSet<String>(params.getInitialPolicies()));
        copy.setKeyPurpose(params.getKeyPurpose());
        copy.setCRLProvider(params.getCRLProvider());
        copy.setExtendedValidationData(params.getExtendedValidationData());
        copy.setDepth(params.getDepth());
        copy.setValidityModel(params.getValidityModel());
        if (params instanceof ValidationParameters) {
            for (Object key : ((ValidationParameters)params).attributes.getKeys()) {
                copy.setAttribute(key, params.getAttribute(key));
            }
        }
        return copy;
    }

    @Override
    public Date basicGetDateToTest() {
        return this.dateToTest;
    }

    @Override
    public ICertificateProvider getAdditionalCerts() {
        if (this.additionalCerts == null) {
            this.setAdditionalCerts(Collections.EMPTY_SET);
        }
        return this.additionalCerts;
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public ICRLProvider getCRLProvider() {
        if (this.crlProvider == null) {
            this.crlProvider = (selector, url) -> Stream.empty();
        }
        return this.crlProvider;
    }

    @Override
    public Date getDateToTest() {
        if (this.basicGetDateToTest() == null) {
            this.dateToTest = DateEnvironment.get().now();
            this.dateSet = false;
        }
        return this.basicGetDateToTest();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public IExtendedValidationData getExtendedValidationData() {
        return this.extendedValidationData;
    }

    @Override
    public Set<String> getInitialPolicies() {
        if (this.initialPolicies == null) {
            this.initialPolicies = new HashSet<String>();
        }
        return this.initialPolicies;
    }

    @Override
    public EnumKeyPurpose getKeyPurpose() {
        return this.keyPurpose;
    }

    @Override
    public ICertificateProvider getTrustedCerts() {
        if (this.trustedCerts == null) {
            this.setTrustedCerts(Collections.EMPTY_SET);
        }
        return this.trustedCerts;
    }

    @Override
    public EnumValidityModel getValidityModel() {
        if (this.validityModel == null) {
            this.validityModel = this.dateSet ? EnumValidityModel.HYBRID_FALLBACK : EnumValidityModel.SHELL_FALLBACK;
        }
        return this.validityModel;
    }

    @Override
    public boolean isConfirmedDate() {
        return this.confirmedDate;
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public void setAdditionalCerts(Collection additionalCerts) {
        this.setAdditionalCerts(new CollectionCertificateProvider(additionalCerts));
    }

    public void setAdditionalCerts(ICertificateProvider additionalCerts) {
        this.additionalCerts = additionalCerts;
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setConfirmedDate(boolean confirmedDate) {
        this.confirmedDate = confirmedDate;
    }

    public void setCRLProvider(ICRLProvider crlProvider) {
        this.crlProvider = crlProvider;
    }

    public void setDateToTest(Date dateToTest) {
        this.setDateToTest(dateToTest, false);
    }

    public void setDateToTest(Date dateToTest, boolean confirmedDate) {
        this.dateToTest = dateToTest;
        this.dateSet = dateToTest != null;
        this.confirmedDate = confirmedDate;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setExtendedValidationData(IExtendedValidationData extendedValidationData) {
        this.extendedValidationData = extendedValidationData;
    }

    public void setInitialPolicies(Set<String> initialPolicies) {
        this.initialPolicies = initialPolicies;
    }

    public void setKeyPurpose(EnumKeyPurpose keyPurpose) {
        this.keyPurpose = keyPurpose;
    }

    public void setTrustedCerts(Collection trustedCerts) {
        this.setTrustedCerts(new CollectionCertificateProvider(trustedCerts));
    }

    public void setTrustedCerts(ICertificateProvider trustedCerts) {
        this.trustedCerts = trustedCerts;
    }

    public void setValidityModel(EnumValidityModel validityModel) {
        this.validityModel = validityModel;
    }
}

