/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.app.validation.ICertificatePathBuilder;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.common.X509CertificatePath;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.StandardCertificateProviderTools;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSCertificatePath;
import de.intarsys.security.validation.IVSCertificatePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CommonPKICertificatePathBuilder
implements ICertificatePathBuilder {
    private boolean stopOnIntermediateTrustAnchor = false;
    private boolean acceptIntermediateTrustAnchor = false;
    private int maxPathLength = 10;

    protected boolean acceptState(IVSCertificatePath state) {
        return !state.isInvalid();
    }

    protected boolean buildAndValidateCertPath(IX509Certificate certificate, IValidationParameters params, List<IX509Certificate> currentPath, List<IVSCertificatePath> states) {
        IX509Certificate trustedEntry;
        if (CertificateTools.containsCertificate(certificate, currentPath)) {
            return false;
        }
        ArrayList<IX509Certificate> newPath = new ArrayList<IX509Certificate>();
        newPath.add(certificate);
        newPath.addAll(currentPath);
        if (CertificateTools.isSelfSigned(certificate)) {
            IVSCertificatePath state = this.validateCertificatePath(newPath, params);
            if (!state.isChainingOk()) {
                return false;
            }
            VSCertificatePath myState = new VSCertificatePath(state);
            IX509Certificate trustedEntry2 = null;
            if (this.isAcceptIntermediateTrustAnchor()) {
                for (IX509Certificate currentCertificate : newPath) {
                    IX509Certificate currentTrustedEntry = StandardCertificateProviderTools.lookupStoredCertificate(params.getTrustedCerts(), currentCertificate);
                    if (currentTrustedEntry == null) continue;
                    trustedEntry2 = currentTrustedEntry;
                }
            } else {
                IX509Certificate currentCertificate = myState.getCertPath().getRootCertificate();
                IX509Certificate currentTrustedEntry = StandardCertificateProviderTools.lookupStoredCertificate(params.getTrustedCerts(), currentCertificate);
                if (currentTrustedEntry != null) {
                    trustedEntry2 = currentTrustedEntry;
                }
            }
            boolean result = false;
            if (trustedEntry2 == null) {
                myState.increaseState(2);
                myState.addMessage(CommonValidationMessages.ERROR_CERTIFICATE_PATH_UNTRUSTED_ROOT());
            } else {
                myState.setTrustAnchor(trustedEntry2);
                result = true;
            }
            states.add(0, myState);
            return result;
        }
        if (this.isStopOnIntermediateTrustAnchor() && (trustedEntry = StandardCertificateProviderTools.lookupStoredCertificate(params.getTrustedCerts(), certificate)) != null) {
            IVSCertificatePath state = this.validateCertificatePath(newPath, params);
            if (!state.isChainingOk()) {
                return false;
            }
            VSCertificatePath myState = new VSCertificatePath(state);
            myState.setTrustAnchor(trustedEntry);
            states.add(0, myState);
            return true;
        }
        if (newPath.size() >= this.getMaxPathLength()) {
            IVSCertificatePath myState = this.validateIncompleteCertificatePath(newPath, params);
            if (myState.isChainingOk()) {
                states.add(myState);
            }
            return false;
        }
        boolean result = this.doBuildAndValidateCertPath(certificate, params, newPath, states);
        if (!result) {
            IX509Certificate trustedEntry3;
            if (this.isAcceptIntermediateTrustAnchor() && (trustedEntry3 = StandardCertificateProviderTools.lookupStoredCertificate(params.getTrustedCerts(), certificate)) != null) {
                IVSCertificatePath state = this.validateCertificatePath(newPath, params);
                if (!state.isChainingOk()) {
                    return false;
                }
                VSCertificatePath myState = new VSCertificatePath(state);
                myState.setTrustAnchor(trustedEntry3);
                states.add(0, myState);
                return true;
            }
            IVSCertificatePath myState = this.validateIncompleteCertificatePath(newPath, params);
            if (myState.isChainingOk()) {
                states.add(myState);
            }
        }
        return result;
    }

    protected boolean buildAndValidateIssuers(Collection<IX509Certificate> issuerCertificates, IValidationParameters params, List<IX509Certificate> currentPath, List<IVSCertificatePath> states) {
        for (IX509Certificate issuerCertificate : issuerCertificates) {
            boolean issuerResult = this.buildAndValidateCertPath(issuerCertificate, params, currentPath, states);
            if (!issuerResult) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized IVSCertificatePath buildCertificatePath(IX509Certificate certificate, IValidationParameters params) {
        ArrayList<IVSCertificatePath> pathStates = new ArrayList<IVSCertificatePath>();
        this.buildAndValidateCertPath(certificate, params, new ArrayList<IX509Certificate>(), pathStates);
        if (pathStates.isEmpty()) {
            VSCertificatePath pathState = new VSCertificatePath(null, 2);
            pathState.addMessage(CommonValidationMessages.ERROR_CERTIFICATE_PATH_DOES_NOT_CHAIN());
            return pathState;
        }
        IVSCertificatePath result = (IVSCertificatePath)pathStates.stream().reduce((vs1, vs2) -> {
            if (vs2.getState() == -1) {
                return vs1;
            }
            if (vs1.getState() == -1) {
                return vs2;
            }
            if (vs1.getState() > vs2.getState()) {
                return vs2;
            }
            return vs1;
        }).get();
        return result;
    }

    protected boolean doBuildAndValidateCertPath(IX509Certificate certificate, IValidationParameters params, List<IX509Certificate> currentPath, List<IVSCertificatePath> states) {
        IX509CertificateFilter[] selectors = CertificateTools.createIssuerSelectors(certificate);
        boolean issuerResult = false;
        Collection<IX509Certificate> issuerCertificates = this.lookupCertificates(params.getTrustedCerts(), selectors);
        issuerResult = this.buildAndValidateIssuers(issuerCertificates, params, currentPath, states);
        if (issuerResult) {
            return true;
        }
        issuerCertificates = this.lookupCertificates(params.getAdditionalCerts(), selectors);
        issuerResult = this.buildAndValidateIssuers(issuerCertificates, params, currentPath, states);
        return issuerResult;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public boolean isAcceptIntermediateTrustAnchor() {
        return this.acceptIntermediateTrustAnchor;
    }

    public boolean isStopOnIntermediateTrustAnchor() {
        return this.stopOnIntermediateTrustAnchor;
    }

    protected Collection<IX509Certificate> lookupCertificates(ICertificateProvider provider, IX509CertificateFilter[] selectors) {
        for (int j = 0; j < selectors.length; ++j) {
            IX509CertificateFilter selector = selectors[j];
            if (selector == null) continue;
            Iterator<IX509Certificate> iResult = provider.lookupCertificates(selector);
            HashSet<IX509Certificate> result = new HashSet<IX509Certificate>();
            while (iResult.hasNext()) {
                result.add(iResult.next());
            }
            if (result.isEmpty()) continue;
            return result;
        }
        return Collections.emptySet();
    }

    public void setAcceptIntermediateTrustAnchor(boolean acceptIntermediateTrustAnchor) {
        this.acceptIntermediateTrustAnchor = acceptIntermediateTrustAnchor;
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public void setStopOnIntermediateTrustAnchor(boolean stopOnIntermediateTrustAnchor) {
        this.stopOnIntermediateTrustAnchor = stopOnIntermediateTrustAnchor;
        if (stopOnIntermediateTrustAnchor) {
            this.setAcceptIntermediateTrustAnchor(true);
        }
    }

    protected IVSCertificatePath validateCertificatePath(List<IX509Certificate> certPath, IValidationParameters params) {
        X509CertificatePath path = new X509CertificatePath(certPath);
        IVSCertificatePath state = ValidationContext.get().getCertificatePathValidator().validateCertificatePath(path, params);
        return state;
    }

    protected IVSCertificatePath validateIncompleteCertificatePath(List<IX509Certificate> path, IValidationParameters params) {
        VSCertificatePath pathState = new VSCertificatePath(this.validateCertificatePath(path, params));
        pathState.increaseState(2);
        pathState.addMessage(CommonValidationMessages.ERROR_CERTIFICATE_PATH_UNTRUSTED_ROOT());
        return pathState;
    }
}

