/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.ades;

import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.common.ValidationStateWalker;
import de.intarsys.security.app.validation.commonpki.ades.PACKAGE;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.standard.validation.VSAdESLTV;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IVSAdESLTV;
import de.intarsys.security.validation.IVSCRL;
import de.intarsys.security.validation.IVSCRLRequest;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSOCSPRequest;
import de.intarsys.security.validation.IVSRevocationRequest;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectHolder;

public class AdESLTVValidator {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final int severity;
    private boolean stopOnTrustAnchor = true;

    public AdESLTVValidator() {
        this(0);
    }

    public AdESLTVValidator(int severity) {
        this.severity = severity;
    }

    protected VSAdESLTV createInitialState(IValidationState state) {
        return new VSAdESLTV(state.getValidationTarget(), 0);
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isStopOnTrustAnchor() {
        return this.stopOnTrustAnchor;
    }

    public void setStopOnTrustAnchor(boolean stopOnTrustAnchor) {
        this.stopOnTrustAnchor = stopOnTrustAnchor;
    }

    public IVSAdESLTV validate(IValidationState state, IValidationParameters parameters) {
        ObjectHolder currentCertificateContext = new ObjectHolder(null);
        ObjectHolder result = new ObjectHolder((Object)this.createInitialState(state));
        ((VSAdESLTV)result.get()).setSeverity(this.getSeverity());
        ValidationStateWalker walker = new ValidationStateWalker((IValueHolder)currentCertificateContext, (IValueHolder)result){
            final /* synthetic */ IValueHolder val$currentCertificateContext;
            final /* synthetic */ IValueHolder val$result;
            {
                this.val$currentCertificateContext = iValueHolder;
                this.val$result = iValueHolder2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void basicVisit(IVSCertificate state) {
                IVSCertificate previousCertificateContext = (IVSCertificate)this.val$currentCertificateContext.get();
                this.val$currentCertificateContext.set((Object)state);
                try {
                    if (state.isUndefined()) {
                        ((VSAdESLTV)this.val$result.get()).increaseState(2);
                        String msg = "No validation information for " + this.getCertificateLabel(state) + " available.";
                        ((VSAdESLTV)this.val$result.get()).addMessage(ValidationMessage.createWarning(msg));
                        return;
                    }
                    if (!this.needsRevocationCheck(state.getX509Certificate())) {
                        return;
                    }
                    VSAdESLTV previousResult = (VSAdESLTV)this.val$result.get();
                    VSAdESLTV ocspLtvState = AdESLTVValidator.this.createInitialState(state);
                    VSAdESLTV crlLtvState = AdESLTVValidator.this.createInitialState(state);
                    this.val$result.set((Object)ocspLtvState);
                    try {
                        IVSOCSP ocspState = state.getOCSPState();
                        if (ocspState == null || ocspState.isUndefined()) {
                            ((VSAdESLTV)this.val$result.get()).increaseState(2);
                            String msg = "No OCSP information for " + this.getCertificateLabel(state) + " available.";
                            ((VSAdESLTV)this.val$result.get()).addMessage(ValidationMessage.createWarning(msg));
                        } else {
                            this.visit(ocspState);
                        }
                        if (!ocspLtvState.isValid()) {
                            this.val$result.set((Object)crlLtvState);
                            IVSCRL crlState = state.getCRLState();
                            if (crlState == null || crlState.isUndefined()) {
                                ((VSAdESLTV)this.val$result.get()).increaseState(2);
                                String msg = "No CRL information for " + this.getCertificateLabel(state) + " available.";
                                ((VSAdESLTV)this.val$result.get()).addMessage(ValidationMessage.createWarning(msg));
                            } else {
                                this.visit(crlState);
                            }
                            if (!crlLtvState.isValid()) {
                                VSAdESLTV majorState = ocspLtvState;
                                if (crlLtvState.getState() > majorState.getState()) {
                                    majorState = crlLtvState;
                                }
                                previousResult.increaseState(majorState);
                                previousResult.addMessages(majorState.getMessages());
                            }
                        }
                    }
                    finally {
                        this.val$result.set((Object)previousResult);
                    }
                }
                finally {
                    this.val$currentCertificateContext.set((Object)previousCertificateContext);
                }
            }

            protected void checkRevocationRequest(IVSRevocationRequest state) {
                if (state.getOrigin() == null) {
                    ((VSAdESLTV)this.val$result.get()).increaseState(2);
                    String msg = "Revocation information checking " + this.getCertificateLabel((IVSCertificate)this.val$currentCertificateContext.get()) + " signed by " + this.getSignerLabel(state) + " without identified origin.";
                    ((VSAdESLTV)this.val$result.get()).addMessage(ValidationMessage.createWarning(msg));
                } else if (state.getOrigin().isExternal()) {
                    ((VSAdESLTV)this.val$result.get()).increaseState(3);
                    String msg = "Revocation information checking " + this.getCertificateLabel((IVSCertificate)this.val$currentCertificateContext.get()) + " signed by " + this.getSignerLabel(state) + " was fetched from " + state.getOrigin().getLabel();
                    ((VSAdESLTV)this.val$result.get()).addMessage(ValidationMessage.createError(msg));
                }
            }

            protected String getCertificateLabel(IVSCertificate state) {
                String unknown = "<unknown>";
                if (state == null) {
                    return unknown;
                }
                IX509Certificate certificate = state.getX509Certificate();
                if (certificate == null) {
                    return unknown;
                }
                return CertificateTools.getSubjectLabel(certificate);
            }

            protected String getSignerLabel(IVSRevocationRequest state) {
                IVSCertificate certificateState = state.getCertificateState();
                return this.getCertificateLabel(certificateState);
            }

            protected boolean needsRevocationCheck(IX509Certificate certificate) {
                if (certificate == null) {
                    return false;
                }
                if (CertificateTools.isSelfSigned(certificate)) {
                    return false;
                }
                byte[] nocheck = certificate.getExtensionValue("1.3.6.1.5.5.7.48.1.5");
                return nocheck == null;
            }

            @Override
            public void visit(IVSCertificatePath state) {
                IX509Certificate trustAnchor = state.getTrustAnchor();
                if (trustAnchor == null) {
                    ((VSAdESLTV)this.val$result.get()).increaseState(3);
                    String msg = "Not validated up to trust anchor.";
                    ((VSAdESLTV)this.val$result.get()).addMessage(ValidationMessage.createWarning(msg));
                } else {
                    IX509Certificate certificate = state.getCertPath().getLeafCertificate();
                    while (!(certificate == null || AdESLTVValidator.this.isStopOnTrustAnchor() && certificate.equals(trustAnchor))) {
                        IVSCertificate certificateState = state.getCertificateState(certificate);
                        this.visit(certificateState);
                        certificate = state.getCertPath().getIssuerCertificate(certificate);
                    }
                }
            }

            @Override
            public void visit(IVSCRLRequest state) {
                this.checkRevocationRequest(state);
                super.visit(state);
            }

            @Override
            public void visit(IVSOCSPRequest state) {
                this.checkRevocationRequest(state);
                super.visit(state);
            }
        };
        walker.visit(state);
        return (IVSAdESLTV)result.get();
    }
}

