/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes;

import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.app.validation.commonpki.qes.PACKAGE;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.VSQualification;
import de.intarsys.security.standard.validation.VSQualificationDefault;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IQCInfo;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSQualification;
import de.intarsys.security.validation.IVSQualificationCertificate;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.tools.message.IMessageBundle;
import java.util.List;

public abstract class QESSignatureEntryReviewer
implements IReviewer<ISignatureEntry, IVSSignatureEntry> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final int severity;

    public QESSignatureEntryReviewer() {
        this(0);
    }

    public QESSignatureEntryReviewer(int pSeverity) {
        this.severity = pSeverity;
    }

    public int getSeverity() {
        return this.severity;
    }

    protected abstract CommonPKIProfile getValidityPolicy();

    @Override
    public IVSSignatureEntry review(ISignatureEntry entry, IVSSignatureEntry state, IValidationParameters parameters) {
        if (entry == null || state == null) {
            return state;
        }
        IVSQualification qState = this.validate(state, parameters);
        ((VSSignatureEntry)state).setQualificationState(qState);
        return state;
    }

    public IVSQualification validate(IVSSignatureEntry state, IValidationParameters parameters) {
        VSQualificationDefault qState = new VSQualificationDefault(0);
        qState.setValidityPolicyID(this.getValidityPolicy());
        qState.setSeverity(this.getSeverity());
        this.validate(state, qState, parameters);
        return qState;
    }

    protected void validate(IVSSignatureEntry state, VSQualification qState, IValidationParameters parameters) {
        List<IVSTimestamp> tsStates;
        IVSCertificate certState = state.getCertificateState();
        if (certState == null) {
            qState.increaseState(2);
            qState.addMessage(ValidationMessage.createError(Msg.getString("QESSignatureEntryReviewer.certificate.certificateStateMissing", new Object[0])));
        } else {
            this.validateCertificateState(certState, qState, parameters);
        }
        List<IVSCertificate> attrCertStates = state.getAttributeCertificateStates();
        if (attrCertStates != null) {
            for (IVSCertificate attrCertState : attrCertStates) {
                this.validateAttributeCertificateState(attrCertState, qState);
            }
        }
        if ((tsStates = state.getTimestampStates()) != null) {
            for (IVSTimestamp tsState : tsStates) {
                this.validateTimestampState(tsState, qState);
            }
        }
    }

    protected void validateAttributeCertificateState(IVSCertificate certState, VSQualification qState) {
        IVSQualificationCertificate certQCState = certState.getQcState();
        int messageSeverity = Math.max(1, certState.getSeverity());
        if (certQCState == null) {
            qState.addMessage(new ValidationMessage(messageSeverity, Msg.getString("QESSignatureEntryReviewer.certificate.qcStateMissing", new Object[0])));
        } else if (!certQCState.isValid()) {
            qState.addMessage(new ValidationMessage(messageSeverity, Msg.getString("QESSignatureEntryReviewer.AttributeCertificateNotQualified", new Object[0])));
        }
    }

    protected void validateCertificateState(IVSCertificate certState, VSQualification qState, IValidationParameters parameters) {
        IVSQualificationCertificate certQCState = certState.getQcState();
        if (certQCState == null) {
            qState.invalidate(Msg.getString("QESSignatureEntryReviewer.certificate.qcStateMissing", new Object[0]));
        } else {
            IQCInfo qcInfo = certQCState.getQcInfo();
            qState.setQcInfo(qcInfo);
            if (!certQCState.isValid()) {
                qState.addMessage(ValidationMessage.createWarning(Msg.getString("QESSignatureEntryReviewer.CertificateNotQualified", new Object[0])));
            }
            qState.increaseState(certQCState.getState());
            if (parameters.getKeyPurpose() == EnumKeyPurpose.DIGITAL_SIGNATURE && !qcInfo.isStoredOnSSCD()) {
                qState.invalidate(ValidationMessage.createWarning(Msg.getString("QESSignatureEntryReviewer.CertificateNotOnQSCD", new Object[0])));
            }
        }
    }

    protected void validateTimestampState(IVSTimestamp tsState, VSQualification qState) {
        IVSQualification tsQState = tsState.getQualificationState();
        if (tsQState == null) {
            qState.addMessage(ValidationMessage.createWarning(Msg.getString("QESSignatureEntryReviewer.timestamp.tsqStateMissing", new Object[0])));
        } else if (!tsQState.isValid()) {
            qState.addMessage(ValidationMessage.createWarning(Msg.getString("QESSignatureEntryReviewer.TimestampNotQualified", new Object[0])));
        }
    }
}

