/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate;

import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.DefaultX509CertificateFactory;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.tools.servicelocator.ServiceImplementation;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

@ServiceImplementation(value=DefaultX509CertificateFactory.class)
public interface IX509CertificateFactory {
    public IX509AttributeCertificate createAttributeCertificate(InputStream var1) throws CertificateException;

    default public IX509AttributeCertificate createAttributeCertificate(byte[] encoded) throws CertificateException {
        return this.createAttributeCertificate(new ByteArrayInputStream(encoded));
    }

    public IX509Certificate createCertificate(InputStream var1) throws CertificateException;

    default public IX509Certificate createCertificate(byte[] encoded) throws CertificateException {
        return this.createCertificate(new ByteArrayInputStream(encoded));
    }

    public IX509PublicKeyCertificate createPublicKeyCertificate(X509Certificate var1);

    public IX509PublicKeyCertificate createPublicKeyCertificate(InputStream var1) throws CertificateException;

    default public IX509PublicKeyCertificate createPublicKeyCertificate(byte[] encoded) throws CertificateException {
        return this.createPublicKeyCertificate(new ByteArrayInputStream(encoded));
    }

    public IX509CRL createCRL(X509CRL var1);

    public IX509CRL createCRL(InputStream var1) throws CRLException;

    default public IX509CRL createCRL(byte[] encoded) throws CRLException {
        return this.createCRL(new ByteArrayInputStream(encoded));
    }
}

