/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;

public class NamingAuthority
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public String getNamingAuthorityId() {
        ASN1ValueHolder first = this.getValueHolder().getChild(0);
        if (ASN1Tools.isInstanceOf((ASN1Encodable)first, ASN1ObjectIdentifier.class)) {
            return first.toDERObjectIdentifier().getId();
        }
        return null;
    }

    public String getNamingAuthorityText() {
        for (int i = 0; i < Math.min(3, this.getValueHolder().size()); ++i) {
            ASN1Primitive obj = this.getValueHolder().getChild(i).toASN1Primitive();
            if (obj instanceof ASN1ObjectIdentifier || obj instanceof DERIA5String) continue;
            return obj.toASN1Primitive().toString();
        }
        return null;
    }

    public String getNamingAuthorityUrl() {
        for (int i = 0; i < Math.min(2, this.getValueHolder().size()); ++i) {
            DERIA5String s;
            ASN1Primitive obj = this.getValueHolder().getChild(i).toASN1Primitive();
            if (!(obj instanceof DERIA5String) || (s = (DERIA5String)obj) == null) continue;
            return s.getString();
        }
        return null;
    }

    public static class Factory
    extends ASN1Based.Factory<NamingAuthority> {
    }
}

