/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;

public class CollectionCertificateProvider
implements ICertificateProvider {
    private Collection<? extends IX509Certificate> certificates;
    private Map<Integer, Set<IX509Certificate>> keyIdentifierToCertificate;
    private Map<Object, Set<IX509Certificate>> subjectToCertificate;
    private EventDispatcher dispatcher;

    public CollectionCertificateProvider(Collection<? extends IX509Certificate> certificates) {
        this.certificates = certificates;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher((Object)this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public boolean containsCertificate(IX509Certificate certificate) {
        if (certificate == null) {
            return false;
        }
        Object key = this.getSubjectKey(certificate);
        Set<IX509Certificate> candidates = null;
        candidates = key == null ? new HashSet<IX509Certificate>(this.certificates) : this.getSubjectToCertificate().get(key);
        if (candidates == null || candidates.isEmpty()) {
            return false;
        }
        for (IX509Certificate candidate : candidates) {
            if (!certificate.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    protected void createIndices() {
        this.subjectToCertificate = new HashMap<Object, Set<IX509Certificate>>();
        this.keyIdentifierToCertificate = new HashMap<Integer, Set<IX509Certificate>>();
        for (IX509Certificate iX509Certificate : this.certificates) {
            this.createIndices(iX509Certificate);
        }
    }

    protected void createIndices(IX509Certificate certificate) {
        Object subject = this.getSubjectKey(certificate);
        if (subject != null) {
            Set<IX509Certificate> subjectSet = this.subjectToCertificate.get(subject);
            if (subjectSet == null) {
                subjectSet = new HashSet<IX509Certificate>();
                this.subjectToCertificate.put(subject, subjectSet);
            }
            subjectSet.add(certificate);
        }
        try {
            byte[] id = CertificateTools.getSubjectKeyIdentifier(certificate);
            if (id != null) {
                Integer key = Arrays.hashCode(id = ASN1Tools.toByteArray((ASN1Encodable[])new ASN1Encodable[]{new DEROctetString(id)}));
                Set<IX509Certificate> idSet = this.keyIdentifierToCertificate.get(key);
                if (idSet == null) {
                    idSet = new HashSet<IX509Certificate>();
                    this.keyIdentifierToCertificate.put(key, idSet);
                }
                idSet.add(certificate);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Map<Integer, Set<IX509Certificate>> getKeyIdentifierToCertificate() {
        if (this.keyIdentifierToCertificate == null) {
            this.createIndices();
        }
        return this.keyIdentifierToCertificate;
    }

    public Object getSubjectKey(IX509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        if (certificate instanceof IX509AttributeCertificate) {
            return ((IX509AttributeCertificate)certificate).getSubject();
        }
        return certificate.getSubjectX500Principal();
    }

    public Map<?, Set<IX509Certificate>> getSubjectToCertificate() {
        if (this.subjectToCertificate == null) {
            this.createIndices();
        }
        return this.subjectToCertificate;
    }

    @Override
    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        Collection candidates = null;
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector selector = (IX509CertificateSelector)filter;
            if (selector.getSubjectKeyIdentifier() != null) {
                Integer key = Arrays.hashCode(selector.getSubjectKeyIdentifier());
                candidates = this.getKeyIdentifierToCertificate().get(key);
            }
            if (selector.getSubject() != null) {
                candidates = this.getSubjectToCertificate().get(selector.getSubject());
            }
        }
        if (candidates == null) {
            candidates = this.certificates;
        }
        return CertificateTools.selectCertificates(filter, candidates);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
        if (this.dispatcher.isEmpty()) {
            this.dispatcher = null;
        }
    }

    protected void triggerChanged() {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"", null, null));
    }
}

