/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter;

import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.tools.reflect.ObjectCreationException;

public class CertificateUsageFilter
implements IX509CertificateFilter {
    public static final CertificateUsageFilter SIGNATURE_QUALIFIED = new CertificateUsageFilter();
    public static final CertificateUsageFilter SIGNATURE_WITH_NONREPUDIATION;
    private boolean qualified = false;
    private boolean checkCRLSign = false;
    private boolean checkDataEncipherment = false;
    private boolean checkDecipherOnly = false;
    private boolean checkDigitalSignature = false;
    private boolean checkDigitalSignatureLax = true;
    private boolean checkEncipherOnly = false;
    private boolean checkKeyAgreement = false;
    private boolean checkKeyCertSign = false;
    private boolean checkKeyEncipherment = false;
    private boolean checkNonRepudiation = false;
    private boolean x509CRLSign;
    private boolean x509DataEncipherment;
    private boolean x509DecipherOnly;
    private boolean x509DigitalSignature;
    private boolean x509EncipherOnly;
    private boolean x509KeyAgreement;
    private boolean x509KeyCertSign;
    private boolean x509KeyEncipherment;
    private boolean x509NonRepudiation;

    public static CertificateUsageFilter createFromCertificateUsage(CertificateUsage usage) {
        CertificateUsageFilter filter = new CertificateUsageFilter();
        if (usage.isX509CRLSign()) {
            filter.setX509CRLSign(true);
        }
        if (usage.isX509DataEncipherment()) {
            filter.setX509DataEncipherment(true);
        }
        if (usage.isX509DecipherOnly()) {
            filter.setX509DecipherOnly(true);
        }
        if (usage.isX509DigitalSignature()) {
            filter.setX509DigitalSignature(true);
        }
        if (usage.isX509EncipherOnly()) {
            filter.setX509EncipherOnly(true);
        }
        if (usage.isX509KeyAgreement()) {
            filter.setX509KeyAgreement(true);
        }
        if (usage.isX509KeyCertSign()) {
            filter.setX509KeyCertSign(true);
        }
        if (usage.isX509KeyEncipherment()) {
            filter.setX509KeyEncipherment(true);
        }
        if (usage.isX509NonRepudiation()) {
            filter.setX509NonRepudiation(true);
        }
        return filter;
    }

    public static CertificateUsageFilter createFromName(String name) throws ObjectCreationException {
        CertificateUsageFilter filter = new CertificateUsageFilter();
        if ("authentication_and_encryption".equals(name)) {
            filter.setX509DigitalSignature(true);
            filter.setX509KeyEncipherment(true);
            return filter;
        }
        if ("encryption".equals(name)) {
            filter.setX509KeyEncipherment(true);
            filter.setX509DataEncipherment(true);
            return filter;
        }
        if ("signature".equals(name)) {
            filter.setX509DigitalSignature(true);
            return filter;
        }
        if ("signature_with_nonrepudiation".equals(name)) {
            filter.setX509DigitalSignature(true);
            filter.setX509NonRepudiation(true);
            filter.setQualified(false);
            return filter;
        }
        if ("qualified_signature".equals(name) || "signature_qualified".equals(name)) {
            filter.setX509DigitalSignature(true);
            filter.setX509NonRepudiation(true);
            filter.setQualified(true);
            return filter;
        }
        if ("signature_without_nonrepudiation".equals(name)) {
            filter.setX509DigitalSignature(true);
            filter.setX509NonRepudiation(false);
            return filter;
        }
        if ("ca".equals(name)) {
            filter.setX509KeyCertSign(true);
            return filter;
        }
        throw new ObjectCreationException("unsupported usage '" + name + "'");
    }

    @Override
    public boolean accept(IX509Certificate certificate) {
        CertificateUsage usage = null;
        if (certificate instanceof IX509PublicKeyCertificate) {
            usage = ((IX509PublicKeyCertificate)certificate).getCertificateUsage();
        }
        if (this.isCheckCRLSign()) {
            if (usage == null) {
                return false;
            }
            if (this.isX509CRLSign() != usage.isX509CRLSign()) {
                return false;
            }
        }
        if (this.isCheckDataEncipherment() && this.isX509DataEncipherment() && !usage.isX509DataEncipherment()) {
            return false;
        }
        if (this.isCheckDecipherOnly() && this.isX509DecipherOnly() && !usage.isX509DecipherOnly()) {
            return false;
        }
        if (!(!this.isCheckDigitalSignature() || !this.isX509DigitalSignature() || usage.isX509DigitalSignature() || this.isCheckDigitalSignatureLax() && usage.isX509NonRepudiation())) {
            return false;
        }
        if (this.isCheckEncipherOnly() && this.isX509EncipherOnly() && !usage.isX509EncipherOnly()) {
            return false;
        }
        if (this.isCheckKeyAgreement() && this.isX509KeyAgreement() && !usage.isX509KeyAgreement()) {
            return false;
        }
        if (this.isCheckKeyCertSign() && this.isX509KeyCertSign() && !usage.isX509KeyCertSign()) {
            return false;
        }
        if (this.isCheckKeyEncipherment() && this.isX509KeyEncipherment() && !usage.isX509KeyEncipherment()) {
            return false;
        }
        return !this.isCheckNonRepudiation() || !this.isX509NonRepudiation() || usage.isX509NonRepudiation();
    }

    public String getName() {
        if (this.isCheckDigitalSignature()) {
            if (this.isCheckNonRepudiation()) {
                if (this.isX509NonRepudiation()) {
                    if (this.isQualified()) {
                        return "signature_qualified";
                    }
                    return "signature_with_nonrepudiation";
                }
                if (this.isX509DigitalSignature()) {
                    return "signature_without_nonrepudiation";
                }
            } else if (this.isX509DigitalSignature() || this.isX509NonRepudiation()) {
                return "signature";
            }
        }
        if (this.isX509NonRepudiation()) {
            if (this.isQualified()) {
                return "signature_qualified";
            }
            return "signature_with_nonrepudiation";
        }
        if (this.isX509DigitalSignature()) {
            return "signature_without_nonrepudiation";
        }
        if (this.x509DataEncipherment && this.x509KeyEncipherment) {
            if (this.isX509DigitalSignature()) {
                return "authentication_and_encryption";
            }
            return "encryption";
        }
        if (this.x509CRLSign || this.x509KeyCertSign) {
            return "ca";
        }
        return "unknown";
    }

    public boolean isCheckCRLSign() {
        return this.checkCRLSign;
    }

    public boolean isCheckDataEncipherment() {
        return this.checkDataEncipherment;
    }

    public boolean isCheckDecipherOnly() {
        return this.checkDecipherOnly;
    }

    public boolean isCheckDigitalSignature() {
        return this.checkDigitalSignature;
    }

    public boolean isCheckDigitalSignatureLax() {
        return this.checkDigitalSignatureLax;
    }

    public boolean isCheckEncipherOnly() {
        return this.checkEncipherOnly;
    }

    public boolean isCheckKeyAgreement() {
        return this.checkKeyAgreement;
    }

    public boolean isCheckKeyCertSign() {
        return this.checkKeyCertSign;
    }

    public boolean isCheckKeyEncipherment() {
        return this.checkKeyEncipherment;
    }

    public boolean isCheckNonRepudiation() {
        return this.checkNonRepudiation;
    }

    public boolean isQualified() {
        return this.qualified;
    }

    public boolean isX509CRLSign() {
        return this.x509CRLSign;
    }

    public boolean isX509DataEncipherment() {
        return this.x509DataEncipherment;
    }

    public boolean isX509DecipherOnly() {
        return this.x509DecipherOnly;
    }

    public boolean isX509DigitalSignature() {
        return this.x509DigitalSignature;
    }

    public boolean isX509EncipherOnly() {
        return this.x509EncipherOnly;
    }

    public boolean isX509KeyAgreement() {
        return this.x509KeyAgreement;
    }

    public boolean isX509KeyCertSign() {
        return this.x509KeyCertSign;
    }

    public boolean isX509KeyEncipherment() {
        return this.x509KeyEncipherment;
    }

    @Override
    public boolean isX509NonRepudiation() {
        return this.x509NonRepudiation;
    }

    public void setCheckCRLSign(boolean checkCRLSign) {
        this.checkCRLSign = checkCRLSign;
    }

    public void setCheckDataEncipherment(boolean checkDataEncipherment) {
        this.checkDataEncipherment = checkDataEncipherment;
    }

    public void setCheckDecipherOnly(boolean checkDecipherOnly) {
        this.checkDecipherOnly = checkDecipherOnly;
    }

    public void setCheckDigitalSignature(boolean checkDigitalSignature) {
        this.checkDigitalSignature = checkDigitalSignature;
    }

    public void setCheckDigitalSignatureLax(boolean checkDigitalSignatureLax) {
        this.checkDigitalSignatureLax = checkDigitalSignatureLax;
    }

    public void setCheckEncipherOnly(boolean checkEencipherOnly) {
        this.checkEncipherOnly = checkEencipherOnly;
    }

    public void setCheckKeyAgreement(boolean checkKeyAgreement) {
        this.checkKeyAgreement = checkKeyAgreement;
    }

    public void setCheckKeyCertSign(boolean checkKeyCertSign) {
        this.checkKeyCertSign = checkKeyCertSign;
    }

    public void setCheckKeyEncipherment(boolean checkKeyEncipherment) {
        this.checkKeyEncipherment = checkKeyEncipherment;
    }

    public void setCheckNonRepudiation(boolean checkNonRepudiation) {
        this.checkNonRepudiation = checkNonRepudiation;
    }

    public void setQualified(boolean qualified) {
        this.qualified = qualified;
    }

    public void setX509CRLSign(boolean x509crlSign) {
        this.checkCRLSign = true;
        this.x509CRLSign = x509crlSign;
    }

    public void setX509DataEncipherment(boolean x509DataEncipherment) {
        this.checkDataEncipherment = true;
        this.x509DataEncipherment = x509DataEncipherment;
    }

    public void setX509DecipherOnly(boolean x509DecipherOnly) {
        this.checkDecipherOnly = true;
        this.x509DecipherOnly = x509DecipherOnly;
    }

    public void setX509DigitalSignature(boolean x509DigitalSignature) {
        this.checkDigitalSignature = true;
        this.x509DigitalSignature = x509DigitalSignature;
    }

    public void setX509EncipherOnly(boolean x509EncipherOnly) {
        this.checkEncipherOnly = true;
        this.x509EncipherOnly = x509EncipherOnly;
    }

    public void setX509KeyAgreement(boolean x509KeyAgreement) {
        this.checkKeyAgreement = true;
        this.x509KeyAgreement = x509KeyAgreement;
    }

    public void setX509KeyCertSign(boolean x509KeyCertSign) {
        this.checkKeyCertSign = true;
        this.x509KeyCertSign = x509KeyCertSign;
    }

    public void setX509KeyEncipherment(boolean x509KeyEncipherment) {
        this.checkKeyEncipherment = true;
        this.x509KeyEncipherment = x509KeyEncipherment;
    }

    public void setX509NonRepudiation(boolean x509NonRepudiation) {
        this.checkNonRepudiation = true;
        this.x509NonRepudiation = x509NonRepudiation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isCheckCRLSign()) {
            sb.append("cRLSign ");
        }
        if (this.isCheckDataEncipherment()) {
            sb.append("dataEncipherment ");
        }
        if (this.isCheckDecipherOnly()) {
            sb.append("decipherOnly ");
        }
        if (this.isCheckDigitalSignature()) {
            sb.append("digitalSignature ");
        }
        if (this.isCheckEncipherOnly()) {
            sb.append("encipherOnly ");
        }
        if (this.isCheckKeyAgreement()) {
            sb.append("keyAgreement ");
        }
        if (this.isCheckKeyCertSign()) {
            sb.append("keyCertSign ");
        }
        if (this.isCheckKeyEncipherment()) {
            sb.append("keyEncipherment ");
        }
        if (this.isCheckNonRepudiation()) {
            sb.append("nonRepudiation ");
        }
        return sb.toString();
    }

    static {
        SIGNATURE_QUALIFIED.setX509DigitalSignature(true);
        SIGNATURE_QUALIFIED.setX509NonRepudiation(true);
        SIGNATURE_QUALIFIED.setQualified(true);
        SIGNATURE_WITH_NONREPUDIATION = new CertificateUsageFilter();
        SIGNATURE_WITH_NONREPUDIATION.setX509DigitalSignature(true);
        SIGNATURE_WITH_NONREPUDIATION.setX509NonRepudiation(true);
        SIGNATURE_WITH_NONREPUDIATION.setQualified(false);
    }
}

