/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter.standard;

import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;

public class ReferencedAttributeCertificateSelector
implements IX509CertificateFilter {
    private BigInteger subjectSerialNumber;
    private X500Principal subjectSubjectX500Principal;
    private X500Principal subjectIssuerX500Principal;
    private BigInteger issuerSerialNumber;
    private X500Principal issuerSubjectX500Principal;

    public static ReferencedAttributeCertificateSelector createFrom(IX509AttributeCertificate attrCert) {
        ReferencedAttributeCertificateSelector selector = new ReferencedAttributeCertificateSelector();
        selector.setSubjectSerialNumber(attrCert.getSubject().getSerialNumber());
        selector.setSubjectSubjectX500Principal(attrCert.getSubject().getSubjectX500Principal());
        selector.setSubjectIssuerX500Principal(attrCert.getSubject().getIssuerX500Principal());
        selector.setIssuerSerialNumber(attrCert.getIssuer().getSerialNumber());
        selector.setIssuerSubjectX500Principal(attrCert.getIssuer().getSubjectX500Principal());
        return selector;
    }

    public static ReferencedAttributeCertificateSelector createFrom(IX509CertificateSelector certSelector) {
        ReferencedAttributeCertificateSelector selector = new ReferencedAttributeCertificateSelector();
        selector.setSubjectSerialNumber(certSelector.getSerialNumber());
        selector.setSubjectSubjectX500Principal(certSelector.getSubject());
        selector.setSubjectIssuerX500Principal(certSelector.getIssuer());
        return selector;
    }

    public static ReferencedAttributeCertificateSelector createFrom(IX509PublicKeyCertificate certificate) {
        ReferencedAttributeCertificateSelector selector = new ReferencedAttributeCertificateSelector();
        selector.setSubjectSerialNumber(certificate.getSerialNumber());
        selector.setSubjectSubjectX500Principal(certificate.getSubjectX500Principal());
        selector.setSubjectIssuerX500Principal(certificate.getIssuerX500Principal());
        return selector;
    }

    @Override
    public boolean accept(IX509Certificate certificate) {
        if (certificate instanceof IX509AttributeCertificate) {
            X500Principal attrPrincipal;
            BigInteger attrSerialNumber;
            IX509AttributeCertificate attr = (IX509AttributeCertificate)certificate;
            if (this.subjectSerialNumber != null && (attrSerialNumber = attr.getSubject().getSerialNumber()) != null && !attrSerialNumber.equals(this.subjectSerialNumber)) {
                return false;
            }
            if (this.subjectSubjectX500Principal != null && (attrPrincipal = attr.getSubject().getSubjectX500Principal()) != null && !attrPrincipal.equals(this.subjectSubjectX500Principal)) {
                return false;
            }
            if (this.subjectIssuerX500Principal != null && (attrPrincipal = attr.getSubject().getIssuerX500Principal()) != null && !attrPrincipal.equals(this.subjectIssuerX500Principal)) {
                return false;
            }
            if (this.issuerSerialNumber != null && (attrSerialNumber = attr.getIssuer().getSerialNumber()) != null && !attrSerialNumber.equals(this.issuerSerialNumber)) {
                return false;
            }
            return this.issuerSubjectX500Principal == null || (attrPrincipal = attr.getIssuer().getSubjectX500Principal()) == null || attrPrincipal.equals(this.issuerSubjectX500Principal);
        }
        return false;
    }

    public BigInteger getIssuerSerialNumber() {
        return this.issuerSerialNumber;
    }

    public X500Principal getIssuerSubjectX500Principal() {
        return this.issuerSubjectX500Principal;
    }

    public X500Principal getSubjectIssuerX500Principal() {
        return this.subjectIssuerX500Principal;
    }

    public BigInteger getSubjectSerialNumber() {
        return this.subjectSerialNumber;
    }

    public X500Principal getSubjectSubjectX500Principal() {
        return this.subjectSubjectX500Principal;
    }

    @Override
    public boolean isX509NonRepudiation() {
        return false;
    }

    public void setIssuerSerialNumber(BigInteger issuerSerialNumber) {
        this.issuerSerialNumber = issuerSerialNumber;
    }

    public void setIssuerSubjectX500Principal(X500Principal issuerSubjectX500Principal) {
        this.issuerSubjectX500Principal = issuerSubjectX500Principal;
    }

    public void setSubjectIssuerX500Principal(X500Principal subjectIssuerX500Principal) {
        this.subjectIssuerX500Principal = subjectIssuerX500Principal;
    }

    public void setSubjectSerialNumber(BigInteger subjectSerialNumer) {
        this.subjectSerialNumber = subjectSerialNumer;
    }

    public void setSubjectSubjectX500Principal(X500Principal subjectSubjectX500Principal) {
        this.subjectSubjectX500Principal = subjectSubjectX500Principal;
    }
}

