/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter.standard;

import de.intarsys.security.certificate.IServiceType;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.filter.SimpleServiceTypeSelector;
import java.math.BigInteger;
import java.security.cert.X509CertSelector;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;

public class X509CertificateFilterChain
implements IX509CertificateSelector,
IX509CertificateFilter {
    private final IX509CertificateFilter selector;
    private IX509CertificateFilter fallbackSelector;

    public X509CertificateFilterChain(IX509CertificateFilter selector, IX509CertificateFilter fallbackSelector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector may not be null");
        }
        this.selector = selector;
        this.fallbackSelector = fallbackSelector;
        if (this.fallbackSelector == null) {
            this.fallbackSelector = new NullSelector();
        }
    }

    @Override
    public boolean accept(IX509Certificate certificate) {
        if (!this.getSelector().accept(certificate)) {
            return false;
        }
        return this.getFallbackSelector().accept(certificate);
    }

    @Override
    public String getAlias() {
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).getAlias() != null) {
            return ((IX509CertificateSelector)this.getSelector()).getAlias();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector) {
            return ((IX509CertificateSelector)this.getFallbackSelector()).getAlias();
        }
        return null;
    }

    public IX509CertificateFilter getFallbackSelector() {
        return this.fallbackSelector;
    }

    @Override
    public X500Principal getIssuer() {
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).getIssuer() != null) {
            return ((IX509CertificateSelector)this.getSelector()).getIssuer();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector) {
            return ((IX509CertificateSelector)this.getFallbackSelector()).getIssuer();
        }
        return null;
    }

    @Override
    public String getSecurityApplication() {
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).getSecurityApplication() != null) {
            return ((IX509CertificateSelector)this.getSelector()).getSecurityApplication();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector) {
            return ((IX509CertificateSelector)this.getFallbackSelector()).getSecurityApplication();
        }
        return null;
    }

    public IX509CertificateFilter getSelector() {
        return this.selector;
    }

    @Override
    public BigInteger getSerialNumber() {
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).getSerialNumber() != null) {
            return ((IX509CertificateSelector)this.getSelector()).getSerialNumber();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector) {
            return ((IX509CertificateSelector)this.getFallbackSelector()).getSerialNumber();
        }
        return null;
    }

    @Override
    public IServiceTypeSelector getServiceTypeSelector() {
        IServiceTypeSelector selector;
        Stream<Object> types = Stream.empty();
        boolean qualifiedOnly = false;
        boolean trustedOnly = false;
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).getServiceTypeSelector() != null) {
            selector = ((IX509CertificateSelector)this.getSelector()).getServiceTypeSelector();
            types = Stream.concat(types, selector.getServiceTypes().stream());
            qualifiedOnly = qualifiedOnly || selector.isQualifiedOnly();
            boolean bl = trustedOnly = trustedOnly || selector.isTrustedOnly();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getFallbackSelector()).getServiceTypeSelector() != null) {
            selector = ((IX509CertificateSelector)this.getFallbackSelector()).getServiceTypeSelector();
            types = Stream.concat(types, selector.getServiceTypes().stream());
            qualifiedOnly = qualifiedOnly || selector.isQualifiedOnly();
            boolean bl = trustedOnly = trustedOnly || selector.isTrustedOnly();
        }
        if (trustedOnly) {
            types = types.filter(st -> st.isTrusted());
        }
        if (qualifiedOnly) {
            types = types.filter(st -> st.isQualified());
        }
        HashSet typeSet = new HashSet(types.collect(Collectors.toList()));
        IServiceType[] typeArray = typeSet.toArray(new IServiceType[typeSet.size()]);
        IServiceTypeSelector selector2 = SimpleServiceTypeSelector.create(typeArray);
        return selector2;
    }

    @Override
    public X500Principal getSubject() {
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).getSubject() != null) {
            return ((IX509CertificateSelector)this.getSelector()).getSubject();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector) {
            return ((IX509CertificateSelector)this.getFallbackSelector()).getSubject();
        }
        return null;
    }

    @Override
    public byte[] getSubjectKeyIdentifier() {
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).getSubjectKeyIdentifier() != null) {
            return ((IX509CertificateSelector)this.getSelector()).getSubjectKeyIdentifier();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector) {
            return ((IX509CertificateSelector)this.getFallbackSelector()).getSubjectKeyIdentifier();
        }
        return null;
    }

    @Override
    public Boolean hasPrivateKey() {
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).hasPrivateKey() != null) {
            return ((IX509CertificateSelector)this.getSelector()).hasPrivateKey();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector) {
            return ((IX509CertificateSelector)this.getFallbackSelector()).hasPrivateKey();
        }
        return null;
    }

    @Override
    public boolean isAcceptAttributeCertificates() {
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).isAcceptAttributeCertificates()) {
            return true;
        }
        boolean accept = true;
        if (this.getFallbackSelector() instanceof IX509CertificateSelector) {
            accept = ((IX509CertificateSelector)this.getFallbackSelector()).isAcceptAttributeCertificates();
        }
        return accept;
    }

    @Override
    public Boolean isPrivateKeyAccessible() {
        if (this.getSelector() instanceof IX509CertificateSelector && ((IX509CertificateSelector)this.getSelector()).isPrivateKeyAccessible() != null) {
            return ((IX509CertificateSelector)this.getSelector()).isPrivateKeyAccessible();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector) {
            return ((IX509CertificateSelector)this.getFallbackSelector()).isPrivateKeyAccessible();
        }
        return null;
    }

    @Override
    public boolean isSubjectMatchStrict() {
        IX509CertificateSelector selector;
        boolean strict = true;
        if (this.getSelector() instanceof IX509CertificateSelector && (selector = (IX509CertificateSelector)this.getSelector()).getSubject() != null) {
            boolean bl = strict = strict && selector.isSubjectMatchStrict();
        }
        if (this.getFallbackSelector() instanceof IX509CertificateSelector && (selector = (IX509CertificateSelector)this.getFallbackSelector()).getSubject() != null) {
            strict = strict && selector.isSubjectMatchStrict();
        }
        return strict;
    }

    @Override
    public boolean isX509NonRepudiation() {
        if (this.getSelector().isX509NonRepudiation()) {
            return true;
        }
        return this.getFallbackSelector().isX509NonRepudiation();
    }

    @Override
    public X509CertSelector toJavaSelector() {
        return null;
    }

    private static final class NullSelector
    implements IX509CertificateFilter {
        private NullSelector() {
        }

        @Override
        public boolean accept(IX509Certificate certificate) {
            return false;
        }

        @Override
        public boolean isX509NonRepudiation() {
            return false;
        }
    }
}

