/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.info;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.certificate.info.X500KnownNames;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.hex.HexTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;

public class X500SimpleName
implements IStringEvaluator {
    private LdapName name;

    public X500SimpleName(String distinguishedName) {
        try {
            this.name = new LdapName(distinguishedName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public X500SimpleName(X500Principal principal) {
        this(principal.toString());
    }

    protected String decodeASN1(byte[] bytes) {
        try {
            ASN1Primitive asn1Obj = ASN1Tools.create((byte[])bytes);
            return asn1Obj.toASN1Primitive().toString();
        }
        catch (IOException e) {
            return "#" + HexTools.bytesToHexString((byte[])bytes);
        }
    }

    public Object evaluate(String expression, IArgs args) {
        if (expression == null) {
            return null;
        }
        String result = this.getByKey(expression.toLowerCase());
        return result == null ? "" : result;
    }

    public String get(String key) {
        if (this.name == null || key == null) {
            return null;
        }
        if ("dn".equals(key.toLowerCase())) {
            return this.getDistinguishedName();
        }
        List<Rdn> result = this.name.getRdns();
        for (Rdn rdn : result) {
            if (!key.equalsIgnoreCase(rdn.getType())) continue;
            Object value = rdn.getValue();
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof byte[]) {
                return this.decodeASN1((byte[])value);
            }
            throw new IllegalStateException();
        }
        return null;
    }

    public List<String> getAll(String key) {
        if (this.name == null || key == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        List<Rdn> rdns = this.name.getRdns();
        for (Rdn rdn : rdns) {
            if (!key.equalsIgnoreCase(rdn.getType())) continue;
            Object value = rdn.getValue();
            if (value instanceof String) {
                result.add((String)value);
                continue;
            }
            if (value instanceof byte[]) {
                result.add(this.decodeASN1((byte[])value));
                continue;
            }
            throw new IllegalStateException();
        }
        return result;
    }

    public String getByKey(String key) {
        if (this.name == null || key == null) {
            return null;
        }
        String result = this.get(key);
        if (result == null) {
            String oid = "oid." + X500KnownNames.OIDS_ALL.get(key.toLowerCase());
            result = this.get(oid);
        }
        return result;
    }

    public String getByOID(String oid) {
        if (this.name == null || oid == null) {
            return null;
        }
        String result = this.get("oid." + oid);
        if (result == null) {
            String key = X500KnownNames.KEYS_ALL.get(oid);
            result = this.get(key);
        }
        return result;
    }

    public String getCommonName() {
        return this.getByKey("CN");
    }

    public String getCountryName() {
        return this.getByKey("C");
    }

    public String getDistinguishedName() {
        return this.name.toString();
    }

    public String getDomainComponent() {
        return this.getByKey("DC");
    }

    public String getEMailAddress() {
        return this.getByKey("EMAILADDRESS");
    }

    public String getGivenName() {
        return this.getByKey("GIVENNAME");
    }

    public String getLocalityName() {
        return this.getByKey("L");
    }

    public String getOrganizationalUnitName() {
        return this.getByKey("OU");
    }

    public String getOrganizationName() {
        return this.getByKey("O");
    }

    public String getPseudonym() {
        return this.getByKey("PSEUDONYM");
    }

    public String getStateOrProvinceName() {
        return this.getByKey("ST");
    }

    public String getStreetAddress() {
        return this.getByKey("STREET");
    }

    public String getSurname() {
        return this.getByKey("SURNAME");
    }

    public String getTitle() {
        return this.getByKey("T");
    }

    public String getUserId() {
        return this.getByKey("UID");
    }

    public String toString() {
        return this.getCommonName();
    }
}

