/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.security.certificate.provider.CertificateProviderRegistry;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class CertificateProviderInstaller
extends ExtensionPointHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(CertificateProviderInstaller.class);
    public static final String XE_CERTIFICATEPROVIDER = "certificateprovider";
    public static final String XP_CERTIFICATEPROVIDERS = "de.intarsys.security.certificateproviders";

    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_CERTIFICATEPROVIDER.equals(element.getName())) {
            try {
                ICertificateProvider provider = (ICertificateProvider)ElementTools.createObject((IElement)element, ICertificateProvider.class, (Object)extension.getProvider(), (IArgs)Args.create());
                CertificateProviderRegistry.get().registerCertificateProvider(provider);
                return provider;
            }
            catch (ObjectCreationException e) {
                String msg = "error creating object";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }

    public boolean isDeferred() {
        return true;
    }
}

