/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificateOwner;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelectorSerializer;
import de.intarsys.security.certificate.provider.CertificateProviderRegistry;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.ICompositeCertificateProvider;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.certificate.provider.keystore.KeyStoreCertificateProvider;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.security.openssl.PEMTools;
import de.intarsys.tools.collection.SingleObjectIterator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locator.StringLocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CertificateProviderTools {
    public static ICertificateProvider createCertificateProvider(Object value) throws ObjectCreationException {
        if (value == null) {
            return null;
        }
        if (value instanceof ICertificateProvider) {
            return (ICertificateProvider)value;
        }
        if (value instanceof KeyStore) {
            return new KeyStoreCertificateProvider((KeyStore)value);
        }
        if (value instanceof IKeyStore) {
            return ((IKeyStore)value).getCertificateProvider();
        }
        try {
            ILocator locator = LocatorTools.createLocator((Object)value, (ILocatorFactory)LocatorFactory.get(), null);
            if (locator != null) {
                IKeyStore facade = KeyStoreFactory.get().create(locator);
                if (facade == null) {
                    throw new ObjectCreationException("can't load keystore '" + locator.getPath() + "'");
                }
                try {
                    facade.load();
                }
                catch (Exception e) {
                    throw new ObjectCreationException("can't load keystore '" + locator.getPath() + "'", (Throwable)e);
                }
                return facade.getCertificateProvider();
            }
            return null;
        }
        catch (IOException e) {
            throw new ObjectCreationException("can't load keystore", (Throwable)e);
        }
    }

    public static IX509Certificate getCertificate(IArgs args, String name, ICertificateProvider provider) throws ObjectCreationException {
        Object selector = args.get(name);
        return CertificateProviderTools.lookupCertificate(provider, selector);
    }

    public static IX509Certificate getCertificate(IArgs args, String name, String providerName, ICertificateProvider defaultProvider) throws ObjectCreationException {
        ICertificateProvider certificateProvider = CertificateProviderTools.getCertificateProvider(args, providerName, defaultProvider);
        return CertificateProviderTools.getCertificate(args, name, certificateProvider);
    }

    public static ICertificateProvider getCertificateProvider(IArgs args, String name, ICertificateProvider defaultProvider) throws ObjectCreationException {
        Object result = args.get(name);
        ICertificateProvider provider = CertificateProviderTools.createCertificateProvider(result);
        if (provider != null) {
            return provider;
        }
        return defaultProvider;
    }

    public static ICertificateProvider getCertificateProvider(IX509Certificate certificate) {
        ICertificateProvider provider = null;
        provider = certificate.getCertificateProvider();
        if (provider == null) {
            provider = CertificateProviderTools.lookupCertificateProvider(certificate);
        }
        return provider;
    }

    public static List<IX509Certificate> getCertificates(IArgs args, String name, ICertificateProvider defaultProvider, String elementName, String providerName) throws ObjectCreationException {
        ArrayList<IX509Certificate> result = new ArrayList<IX509Certificate>();
        List<IX509CertificateSelector> identifiers = null;
        Object identifiersObj = args.get(name);
        if (identifiersObj instanceof Collection) {
            identifiers = (List<IX509CertificateSelector>)args.get(name);
        } else if (identifiersObj instanceof String) {
            try {
                X509CertificateSelectorSerializer factory = new X509CertificateSelectorSerializer();
                identifiers = factory.deserializeList((String)identifiersObj);
            }
            catch (IOException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        if (identifiers == null) {
            return result;
        }
        for (Object e : identifiers) {
            IX509Certificate certificate = CertificateProviderTools.lookupCertificate(defaultProvider, e);
            if (certificate == null) {
                IArgs identifierArgs = null;
                if (e instanceof IArgs) {
                    identifierArgs = (IArgs)e;
                } else if (e instanceof Map) {
                    identifierArgs = new Args((Map)e);
                }
                if (identifierArgs != null) {
                    certificate = CertificateProviderTools.getCertificate(identifierArgs, elementName, providerName, defaultProvider);
                }
            }
            if (certificate == null) continue;
            result.add(certificate);
        }
        return result;
    }

    public static IX509Certificate lookupCertificate(ICertificateProvider provider, Object object) throws ObjectCreationException {
        Iterator<IX509Certificate> certificates = CertificateProviderTools.lookupCertificates(provider, object);
        if (certificates.hasNext()) {
            return certificates.next();
        }
        return null;
    }

    public static ICertificateProvider lookupCertificateProvider(IX509Certificate certificate) {
        return CertificateProviderTools.lookupCertificateProvider(certificate, CertificateProviderRegistry.get());
    }

    public static ICertificateProvider lookupCertificateProvider(IX509Certificate certificate, ICompositeCertificateProvider composite) {
        for (ICertificateProvider child : composite.getCertificateProviders()) {
            if (child instanceof ICompositeCertificateProvider) {
                ICertificateProvider childProvider = CertificateProviderTools.lookupCertificateProvider(certificate, (ICompositeCertificateProvider)((Object)child));
                if (childProvider == null) continue;
                return childProvider;
            }
            if (!child.containsCertificate(certificate)) continue;
            return child;
        }
        return null;
    }

    public static Iterator<IX509Certificate> lookupCertificates(ICertificateProvider provider, Object object) throws ObjectCreationException {
        if (object == null) {
            return Collections.emptyIterator();
        }
        if (object instanceof IArgs) {
            IArgs args = (IArgs)object;
            String pem = ArgTools.getString((IArgs)args, (String)"pem", null);
            try {
                object = StringTools.isEmpty((String)pem) ? LocatorTools.createLocator((Object)args, (ILocatorFactory)LocatorFactory.get(), null) : new StringLocator(pem, "certificate.pem");
            }
            catch (IOException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            try {
                object = X509CertificateFactory.get().createCertificate(bytes);
            }
            catch (CertificateException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        if (object instanceof ILocator) {
            ILocator locator = (ILocator)object;
            if (KeyStoreFacade.isPEM(locator)) {
                try {
                    object = PEMTools.readPEMCertificate(locator);
                }
                catch (IOException e) {
                    throw new ObjectCreationException((Throwable)e);
                }
            }
            try {
                object = X509CertificateFactory.get().createCertificate(((ILocator)object).getInputStream());
            }
            catch (IOException | CertificateException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof IX509Certificate) {
            return new SingleObjectIterator(object);
        }
        if (object instanceof IX509PublicKeyCertificateOwner) {
            return new SingleObjectIterator((Object)((IX509PublicKeyCertificateOwner)object).getX509PublicKeyCertificate());
        }
        if (provider == null) {
            return Collections.emptyIterator();
        }
        IX509CertificateFilter filter = CertificateFilterTools.createCertificateFilter(object);
        if (filter == null) {
            return Collections.emptyIterator();
        }
        return provider.lookupCertificates(filter);
    }
}

