/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.ICompositeCertificateProvider;
import de.intarsys.tools.collection.NestedIterator;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.reflect.ClassTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeCertificateProvider
implements ICertificateProvider,
ICompositeCertificateProvider,
INotificationSupport {
    private final List<ICertificateProvider> delegateProviders = new ArrayList<ICertificateProvider>();
    private final List armed = new ArrayList();
    private EventDispatcher dispatcher;
    private String name;
    private final INotificationListener listenDelegateChanged = new INotificationListener(){

        public void handleEvent(Event event) {
            CompositeCertificateProvider.this.triggerChanged();
        }
    };

    public static ICertificateProvider append(ICertificateProvider a, ICertificateProvider b) {
        CompositeCertificateProvider result;
        if (a == null) {
            return b;
        }
        if (a instanceof CompositeCertificateProvider) {
            result = (CompositeCertificateProvider)a;
        } else {
            result = new CompositeCertificateProvider();
            result.registerCertificateProvider(a);
        }
        result.registerCertificateProvider(b);
        return result;
    }

    public CompositeCertificateProvider() {
        this.setName("generic-" + this.hashCode());
    }

    public CompositeCertificateProvider(String name) {
        this.name = name;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher((Object)this);
            for (Object tempObject : this.armed) {
                if (!(tempObject instanceof INotificationSupport)) continue;
                ((INotificationSupport)tempObject).addNotificationListener(AttributeChangedEvent.ID, this.listenDelegateChanged);
            }
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected void arm(Object provider) {
        if (this.armed.contains(provider)) {
            return;
        }
        this.armed.add(provider);
        if (this.dispatcher == null || this.dispatcher.isEmpty()) {
            return;
        }
        if (provider instanceof INotificationSupport) {
            ((INotificationSupport)provider).addNotificationListener(AttributeChangedEvent.ID, this.listenDelegateChanged);
        }
    }

    public void clear() {
        for (ICertificateProvider certificateProvider : this.getCertificateProviders()) {
            this.unregisterCertificateProvider(certificateProvider);
        }
    }

    @Override
    public boolean containsCertificate(IX509Certificate certificate) {
        for (ICertificateProvider delegate : this.getCertificateProviders()) {
            if (!delegate.containsCertificate(certificate)) continue;
            return true;
        }
        return false;
    }

    protected void disarm(Object provider) {
        this.armed.remove(provider);
        if (this.dispatcher == null || this.dispatcher.isEmpty()) {
            return;
        }
        if (provider instanceof INotificationSupport) {
            ((INotificationSupport)provider).removeNotificationListener(AttributeChangedEvent.ID, this.listenDelegateChanged);
        }
    }

    @Override
    public List<ICertificateProvider> getCertificateProviders() {
        return new ArrayList<ICertificateProvider>(this.delegateProviders);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        ArrayList<Iterator<IX509Certificate>> result = new ArrayList<Iterator<IX509Certificate>>();
        for (ICertificateProvider delegate : this.getCertificateProviders()) {
            Iterator<IX509Certificate> delegateResult = delegate.lookupCertificates(filter);
            result.add(delegateResult);
        }
        return new NestedIterator(result.iterator());
    }

    @Override
    public void registerCertificateProvider(ICertificateProvider provider) {
        this.delegateProviders.add(provider);
        this.arm(provider);
        this.triggerChanged();
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
        if (this.dispatcher.isEmpty()) {
            this.dispatcher = null;
            for (Object tempObject : this.armed) {
                if (!(tempObject instanceof INotificationSupport)) continue;
                ((INotificationSupport)tempObject).removeNotificationListener(AttributeChangedEvent.ID, this.listenDelegateChanged);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return ClassTools.getUnqualifiedName(this.getClass()) + "-" + this.getName();
    }

    protected void triggerChanged() {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"", null, null));
    }

    @Override
    public void unregisterCertificateProvider(ICertificateProvider provider) {
        this.disarm(provider);
        this.delegateProviders.remove(provider);
        this.triggerChanged();
    }
}

