/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider;

import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.InstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProviderRegistry;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredCertificateProviderRegistry
extends CompositeCertificateProvider
implements ICertificateProviderRegistry {
    private static final Logger Log = LoggerFactory.getLogger(DeferredCertificateProviderRegistry.class);

    public DeferredCertificateProviderRegistry() {
        super("deferred");
    }

    @Override
    public boolean containsCertificate(IX509Certificate certificate) {
        this.registerExtensions();
        return super.containsCertificate(certificate);
    }

    @Override
    public List<ICertificateProvider> getCertificateProviders() {
        this.registerExtensions();
        return super.getCertificateProviders();
    }

    @Override
    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        this.registerExtensions();
        return super.lookupCertificates(filter);
    }

    protected void registerExtensions() {
        IExtensionPoint ep = InstrumentRegistry.get().lookupExtensionPoint("de.intarsys.security.certificateproviders");
        if (ep == null) {
            Log.warn("extension point 'de.intarsys.security.certificateproviders' not available");
        } else {
            ExtensionPointHandlerAdapter installer = (ExtensionPointHandlerAdapter)ep.getInstaller();
            try {
                installer.install();
            }
            catch (InstrumentRegistryException e) {
                Log.warn("extension point 'de.intarsys.security.certificateproviders' service installation failed", (Throwable)e);
            }
        }
    }
}

