/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.ldap;

import de.intarsys.security.certstore.ldap.LDAPCertStoreParameters;
import de.intarsys.security.ldap.X509Directory;
import de.intarsys.security.tools.X500NameTools;
import de.intarsys.tools.hex.HexTools;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.CertificatePair;
import org.bouncycastle.x509.X509CertificatePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPCertStoreSpi
extends CertStoreSpi {
    private static final Logger Log = LoggerFactory.getLogger(LDAPCertStoreSpi.class);
    private static final String[] STRING0 = new String[0];
    private static final byte[][] BB0 = new byte[0][];
    private static final Attributes EMPTY_ATTRIBUTES = new BasicAttributes();
    private CertificateFactory cf;
    private DirContext ctx;
    private String baseName;
    private boolean prefetchCRLs = false;
    private int requests = 0;
    private Map<String, Set<String>> contextMap = new HashMap<String, Set<String>>();

    public LDAPCertStoreSpi(CertStoreParameters certstoreparameters) throws InvalidAlgorithmParameterException {
        super(certstoreparameters);
        if (!(certstoreparameters instanceof LDAPCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be LDAPCertStoreParameters");
        }
        LDAPCertStoreParameters ldapcertstoreparameters = (LDAPCertStoreParameters)certstoreparameters;
        this.createInitialDirContext(ldapcertstoreparameters);
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateexception) {
            throw new InvalidAlgorithmParameterException("unable to create CertificateFactory for X.509");
        }
    }

    protected Set<String> basicDetermineCertificateContextNames(String nameString) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.tryContext(""));
        names.addAll(this.tryContext(nameString));
        X500Name name = new X500Name(nameString);
        String c = X500NameTools.getComponentString(name, BCStyle.C);
        String o = X500NameTools.getComponentString(name, BCStyle.O);
        String ou = X500NameTools.getComponentString(name, BCStyle.OU);
        String cn = X500NameTools.getComponentString(name, BCStyle.CN);
        if (c != null && o != null) {
            String oContext = "O=" + o + ",C=" + c;
            names.addAll(this.tryContext(oContext));
            if (ou != null) {
                String ouContext = "OU=" + ou + "," + oContext;
                names.addAll(this.tryContext(ouContext));
                if (cn != null) {
                    String cnContext = "CN=" + cn + "," + ouContext;
                    names.addAll(this.tryContext(cnContext));
                }
            }
            if (cn != null) {
                String cnContext = "CN=" + cn + "," + oContext;
                names.addAll(this.tryContext(cnContext));
            }
        }
        return names;
    }

    private void createInitialDirContext(LDAPCertStoreParameters params) throws InvalidAlgorithmParameterException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", params.getUrl());
        env.put("java.naming.referral", "follow");
        this.baseName = params.getBaseDN();
        try {
            this.ctx = new InitialDirContext(env);
            Hashtable<?, ?> hashtable1 = this.ctx.getEnvironment();
            if (hashtable1.get("java.naming.referral") == null) {
                this.ctx.addToEnvironment("java.naming.referral", "follow");
            }
        }
        catch (NamingException namingexception) {
            Log.trace("LDAPCertStoreSpi.engineInit about to throw InvalidAlgorithmParameterException");
            namingexception.printStackTrace();
            InvalidAlgorithmParameterException invalidalgorithmparameterexception = new InvalidAlgorithmParameterException("unable to create InitialDirContext using supplied parameters");
            invalidalgorithmparameterexception.initCause(namingexception);
            throw invalidalgorithmparameterexception;
        }
    }

    protected Set<String> determineCertificateContextNames(String nameString) {
        Set<String> result = this.contextMap.get(nameString + "|certificate");
        if (result == null) {
            result = this.basicDetermineCertificateContextNames(nameString);
            this.contextMap.put(nameString, result);
        }
        return result;
    }

    @Override
    public synchronized Collection<? extends Certificate> engineGetCertificates(CertSelector certselector) throws CertStoreException {
        Set<String> contextNames;
        Log.trace("LDAPCertStoreSpi.engineGetCertificates() selector: " + String.valueOf(certselector));
        if (certselector == null) {
            certselector = new X509CertSelector();
        }
        if (!(certselector instanceof X509CertSelector)) {
            throw new CertStoreException("LDAPCertStore needs an X509CertSelector to find certs");
        }
        X509CertSelector x509certselector = (X509CertSelector)certselector;
        int i = x509certselector.getBasicConstraints();
        String s = x509certselector.getSubject() == null ? null : x509certselector.getSubject().getName("RFC1779");
        String s1 = x509certselector.getIssuer() == null ? null : x509certselector.getIssuer().getName("RFC1779");
        HashSet<? extends Certificate> hashset = new HashSet<Certificate>();
        Log.trace("LDAPCertStoreSpi.engineGetCertificates() basicConstraints: " + i);
        if (s != null) {
            Log.trace("LDAPCertStoreSpi.engineGetCertificates() subject is not null");
            contextNames = this.determineCertificateContextNames(s);
            for (String contextName : contextNames) {
                LDAPRequest ldaprequest = new LDAPRequest(contextName);
                if (i > -2) {
                    ldaprequest.addRequestedAttributes(X509Directory.ATTR_CROSS_CERTIFICATE_PAIR_ALL);
                    ldaprequest.addRequestedAttributes(X509Directory.ATTR_CA_CERTIFICATE_ALL);
                    ldaprequest.addRequestedAttributes(X509Directory.ATTR_AUTHORITY_REVOCATION_LIST_ALL);
                    if (this.prefetchCRLs) {
                        ldaprequest.addRequestedAttribute("certificateRevocationList;binary");
                    }
                }
                if (i < 0) {
                    ldaprequest.addRequestedAttributes(X509Directory.ATTR_USER_CERTIFICATE_ALL);
                }
                if (i > -2) {
                    hashset.addAll(this.getMatchingCrossCerts(ldaprequest, x509certselector, null));
                    Log.trace("LDAPCertStoreSpi.engineGetCertificates() after getMatchingCrossCerts(subject,xsel,null),certs.size(): " + hashset.size());
                    hashset.addAll(this.getCertificates(ldaprequest, X509Directory.ATTR_CA_CERTIFICATE_ALL, x509certselector));
                    Log.trace("LDAPCertStoreSpi.engineGetCertificates() after getCertificates(subject,CA_CERT,xsel),certs.size(): " + hashset.size());
                }
                if (i >= 0) continue;
                hashset.addAll(this.getCertificates(ldaprequest, X509Directory.ATTR_USER_CERTIFICATE_ALL, x509certselector));
                Log.trace("LDAPCertStoreSpi.engineGetCertificates() after getCertificates(subject,USER_CERT, xsel),certs.size(): " + hashset.size());
            }
        } else {
            Log.trace("LDAPCertStoreSpi.engineGetCertificates() subject is null");
            if (i == -2) {
                throw new CertStoreException("need subject to find EE certs");
            }
            if (s1 == null) {
                throw new CertStoreException("need subject or issuer to find certs");
            }
        }
        Log.trace("LDAPCertStoreSpi.engineGetCertificates() about to getMatchingCrossCerts...");
        if (s1 != null && i > -2) {
            contextNames = this.determineCertificateContextNames(s1);
            for (String contextName : contextNames) {
                LDAPRequest ldaprequest1 = new LDAPRequest(contextName);
                ldaprequest1.addRequestedAttributes(X509Directory.ATTR_CROSS_CERTIFICATE_PAIR_ALL);
                ldaprequest1.addRequestedAttributes(X509Directory.ATTR_CA_CERTIFICATE_ALL);
                ldaprequest1.addRequestedAttributes(X509Directory.ATTR_AUTHORITY_REVOCATION_LIST_ALL);
                if (this.prefetchCRLs) {
                    ldaprequest1.addRequestedAttributes(X509Directory.ATTR_CERTIFICATE_REVOCATION_LIST_ALL);
                }
                hashset.addAll(this.getMatchingCrossCerts(ldaprequest1, null, x509certselector));
                Log.trace("LDAPCertStoreSpi.engineGetCertificates() after getMatchingCrossCerts(issuer,null,xsel),certs.size(): " + hashset.size());
                hashset.addAll(this.getCertificates(ldaprequest1, X509Directory.ATTR_CA_CERTIFICATE_ALL, x509certselector));
                Log.trace("LDAPCertStoreSpi.engineGetCertificates() after getCertificates(issuer,CA_CERT,xsel),certs.size(): " + hashset.size());
            }
        }
        Log.trace("LDAPCertStoreSpi.engineGetCertificates() returning certs");
        return hashset;
    }

    @Override
    public synchronized Collection<? extends CRL> engineGetCRLs(CRLSelector crlselector) throws CertStoreException {
        Collection<Object> obj;
        Log.trace("LDAPCertStoreSpi.engineGetCRLs() selector: " + crlselector);
        if (crlselector == null) {
            crlselector = new X509CRLSelector();
        }
        if (!(crlselector instanceof X509CRLSelector)) {
            throw new CertStoreException("need X509CRLSelector to find CRLs");
        }
        X509CRLSelector x509crlselector = (X509CRLSelector)crlselector;
        HashSet hashset = new HashSet();
        X509Certificate x509certificate = x509crlselector.getCertificateChecking();
        if (x509certificate != null) {
            HashSet<Object> set = new HashSet<Object>();
            X500Principal x500principal = x509certificate.getIssuerX500Principal();
            String name = x500principal.getName("RFC2253");
            set.add(name);
            obj = set;
        } else {
            obj = x509crlselector.getIssuerNames();
            if (obj == null) {
                throw new CertStoreException("need issuerNames or certChecking to find CRLs");
            }
        }
        for (Object obj1 : obj) {
            String s;
            block15: {
                if (obj1 instanceof byte[]) {
                    try {
                        X500Principal x500principal1 = new X500Principal((byte[])obj1);
                        s = x500principal1.getName("RFC2253");
                        break block15;
                    }
                    catch (IllegalArgumentException illegalargumentexception) {
                        continue;
                    }
                }
                s = (String)obj1;
            }
            Collection<Object> obj2 = Collections.emptyList();
            if (x509certificate == null || x509certificate.getBasicConstraints() != -1) {
                LDAPRequest ldaprequest = new LDAPRequest(s);
                ldaprequest.addRequestedAttributes(X509Directory.ATTR_CROSS_CERTIFICATE_PAIR_ALL);
                ldaprequest.addRequestedAttributes(X509Directory.ATTR_CA_CERTIFICATE_ALL);
                ldaprequest.addRequestedAttributes(X509Directory.ATTR_AUTHORITY_REVOCATION_LIST_ALL);
                if (this.prefetchCRLs) {
                    ldaprequest.addRequestedAttributes(X509Directory.ATTR_CERTIFICATE_REVOCATION_LIST_ALL);
                }
                try {
                    obj2 = this.getCRLs(ldaprequest, X509Directory.ATTR_AUTHORITY_REVOCATION_LIST_ALL, x509crlselector);
                    if (obj2.isEmpty()) {
                        this.prefetchCRLs = true;
                    }
                }
                catch (CertStoreException certstoreexception) {
                    Log.trace("LDAPCertStoreSpi.engineGetCRLs non-fatal error retrieving ARLs:" + certstoreexception);
                    certstoreexception.printStackTrace();
                }
            }
            if (obj2.isEmpty()) {
                LDAPRequest ldaprequest1 = new LDAPRequest(s);
                ldaprequest1.addRequestedAttributes(X509Directory.ATTR_CERTIFICATE_REVOCATION_LIST_ALL);
                obj2 = this.getCRLs(ldaprequest1, X509Directory.ATTR_CERTIFICATE_REVOCATION_LIST_ALL, x509crlselector);
            }
            hashset.addAll(obj2);
        }
        return hashset;
    }

    private Collection<? extends Certificate> getCertificates(LDAPRequest ldaprequest, String[] s, CertSelector certselector) throws CertStoreException {
        byte[][] abyte0;
        try {
            abyte0 = ldaprequest.getValues(s);
        }
        catch (NamingException namingexception) {
            throw new CertStoreException(namingexception);
        }
        int i = abyte0.length;
        if (i == 0) {
            return Collections.emptyList();
        }
        ArrayList<Certificate> arraylist = new ArrayList<Certificate>(i);
        for (int j = 0; j < i; ++j) {
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0[j]);
            try {
                Certificate certificate = this.cf.generateCertificate(bytearrayinputstream);
                if (!certselector.match(certificate)) continue;
                arraylist.add(certificate);
                continue;
            }
            catch (CertificateException certificateException) {
                Log.trace("LDAPCertStoreSpi.getCertificates() encountered exception while parsing cert, skipping the bad data: ");
                Log.trace("[ " + HexTools.bytesToHexDump((byte[])abyte0[j], (int)0, (int)abyte0[j].length, (int)8, (int)2, (boolean)true, (boolean)true) + " ]");
            }
        }
        return arraylist;
    }

    private Collection<X509CertificatePair> getCertPairs(LDAPRequest ldaprequest, String[] s) throws CertStoreException {
        byte[][] abyte0;
        try {
            abyte0 = ldaprequest.getValues(s);
        }
        catch (NamingException namingexception) {
            throw new CertStoreException(namingexception);
        }
        int i = abyte0.length;
        if (i == 0) {
            return Collections.emptyList();
        }
        ArrayList<X509CertificatePair> arraylist = new ArrayList<X509CertificatePair>(i);
        for (int j = 0; j < i; ++j) {
            try {
                X509CertificatePair x509certificatepair = new X509CertificatePair(CertificatePair.getInstance((Object)abyte0[j]));
                arraylist.add(x509certificatepair);
                continue;
            }
            catch (CertificateException certificateException) {
                Log.trace("LDAPCertStoreSpi.getCertPairs() encountered exception while parsing cert, skipping the bad data: ");
                Log.trace("[ " + HexTools.bytesToHexDump((byte[])abyte0[j], (int)0, (int)abyte0[j].length, (int)8, (int)2, (boolean)true, (boolean)true) + " ]");
            }
        }
        return arraylist;
    }

    private Collection<? extends CRL> getCRLs(LDAPRequest ldaprequest, String[] s, CRLSelector crlselector) throws CertStoreException {
        byte[][] abyte0;
        try {
            abyte0 = ldaprequest.getValues(s);
        }
        catch (NamingException namingexception) {
            throw new CertStoreException(namingexception);
        }
        int i = abyte0.length;
        if (i == 0) {
            return Collections.emptyList();
        }
        ArrayList<CRL> arraylist = new ArrayList<CRL>(i);
        for (int j = 0; j < i; ++j) {
            try {
                CRL crl = this.cf.generateCRL(new ByteArrayInputStream(abyte0[j]));
                if (!crlselector.match(crl)) continue;
                arraylist.add(crl);
                continue;
            }
            catch (CRLException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Log.trace("LDAPCertStoreSpi.getCRLs() encountered exception while parsing CRL, skipping the bad data: ");
        }
        return arraylist;
    }

    protected String getFullName(Binding binding) throws NamingException {
        int pos;
        String bindingName = binding.getNameInNamespace();
        if (this.baseName != null && (pos = bindingName.lastIndexOf(this.baseName)) > -1) {
            bindingName = bindingName.substring(0, pos - 1);
        }
        return bindingName;
    }

    private Collection<? extends Certificate> getMatchingCrossCerts(LDAPRequest ldaprequest, CertSelector certselector, CertSelector certselector1) throws CertStoreException {
        Collection<X509CertificatePair> collection = this.getCertPairs(ldaprequest, X509Directory.ATTR_CROSS_CERTIFICATE_PAIR_ALL);
        ArrayList<X509Certificate> arraylist = new ArrayList<X509Certificate>();
        for (X509CertificatePair x509certificatepair : collection) {
            X509Certificate x509certificate1;
            X509Certificate x509certificate;
            if (certselector != null && (x509certificate = x509certificatepair.getForward()) != null && certselector.match(x509certificate)) {
                arraylist.add(x509certificate);
            }
            if (certselector1 == null || (x509certificate1 = x509certificatepair.getReverse()) == null || !certselector1.match(x509certificate1)) continue;
            arraylist.add(x509certificate1);
        }
        return arraylist;
    }

    protected Set<String> tryContext(String contextName) {
        HashSet<String> result = new HashSet<String>();
        DirContext context = null;
        try {
            context = (DirContext)this.ctx.lookup(contextName);
            result.add(contextName);
        }
        catch (NamingException e) {
            return result;
        }
        try {
            NamingEnumeration<Binding> bindings = context.listBindings("");
            while (bindings.hasMore()) {
                Binding binding = bindings.next();
                String bindingName = this.getFullName(binding);
                result.add(bindingName);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return result;
    }

    private class LDAPRequest {
        private String name;
        private Map<String, byte[][]> valueMap;
        private final List<String> requestedAttributes = new ArrayList<String>();

        LDAPRequest(String name) {
            this.name = name;
        }

        void addRequestedAttribute(String s) {
            if (this.valueMap != null) {
                throw new IllegalStateException("Request already sent");
            }
            this.requestedAttributes.add(s);
        }

        void addRequestedAttributes(String[] s) {
            if (this.valueMap != null) {
                throw new IllegalStateException("Request already sent");
            }
            for (int i = 0; i < s.length; ++i) {
                this.requestedAttributes.add(s[i]);
            }
        }

        private byte[][] getAttributeValues(Attribute attribute) throws NamingException {
            Object abyte0;
            if (attribute == null) {
                abyte0 = BB0;
            } else {
                abyte0 = new byte[attribute.size()][];
                int i = 0;
                NamingEnumeration<?> namingenumeration = attribute.getAll();
                while (namingenumeration.hasMore()) {
                    Object obj = namingenumeration.next();
                    Log.trace("LDAPCertStoreSpi.getAttrValues() enum.next is a string!: " + obj);
                    byte[] abyte1 = (byte[])obj;
                    abyte0[i++] = abyte1;
                }
            }
            return abyte0;
        }

        private Map<String, byte[][]> getValueMap() throws NamingException {
            Attributes attributes;
            if (this.valueMap != null) {
                return this.valueMap;
            }
            this.valueMap = new HashMap<String, byte[][]>(8);
            String[] as = this.requestedAttributes.toArray(STRING0);
            try {
                attributes = LDAPCertStoreSpi.this.ctx.getAttributes(this.name, as);
            }
            catch (NameNotFoundException namenotfoundexception) {
                attributes = EMPTY_ATTRIBUTES;
            }
            for (String s : this.requestedAttributes) {
                Attribute attribute = attributes.get(s);
                byte[][] abyte0 = this.getAttributeValues(attribute);
                this.valueMap.put(s, abyte0);
            }
            return this.valueMap;
        }

        byte[][] getValues(String s) throws NamingException {
            Map<String, byte[][]> map = this.getValueMap();
            byte[][] abyte1 = map.get(s);
            return abyte1;
        }

        byte[][] getValues(String[] s) throws NamingException {
            for (int i = 0; i < s.length; ++i) {
                byte[][] result = this.getValues(s[i]);
                if (result == null || result.length <= 0) continue;
                return result;
            }
            return BB0;
        }
    }
}

