/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.digest;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestTools {
    private static final Logger Log = LoggerFactory.getLogger(DigestTools.class);

    public static void checkHash(byte[] hash, String hashAlgorithm) {
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithm(hashAlgorithm);
        if (hash.length != algorithm.getSize()) {
            throw new IllegalArgumentException("Invalid digest value length");
        }
    }

    public static IDigester getDigester(IArgs args, String defaultValue) {
        Object value = args.get("digester");
        if (value == null) {
            value = defaultValue;
        }
        return DigestTools.getDigester(value);
    }

    public static IDigester getDigester(Object value) {
        if (value instanceof IDigester) {
            return (IDigester)value;
        }
        if (value instanceof DigestAlgorithm) {
            value = ((DigestAlgorithm)value).getCanonicalName();
        }
        try {
            String algorithmName = (String)ConverterRegistry.get().convert(value, String.class);
            String canonicalName = DigestAlgorithm.lookupAlgorithmName(algorithmName);
            return de.intarsys.tools.digest.DigestTools.createDigester((String)canonicalName);
        }
        catch (ConversionException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("hash algorithm " + value + " invalid", e);
        }
    }

    public static IDigester getDigesterOrSha1(IArgs args, String defaultValue) {
        try {
            return DigestTools.getDigester(args, defaultValue);
        }
        catch (Exception e) {
            Log.warn("fall back to SHA1 ({})", (Object)e.getLocalizedMessage(), (Object)e);
            return DigestTools.getDigester("SHA-1");
        }
    }

    public static IDigester getDigesterOrSha1(IArgs args, String defaultValue, Collection<String> supportedHashAlgorithms) {
        Object digester = args.get("digester");
        if (digester == null) {
            digester = defaultValue;
        }
        if (digester instanceof IDigester) {
            return (IDigester)digester;
        }
        try {
            String algorithmName = (String)ConverterRegistry.get().convert(digester, String.class);
            String tempName = DigestTools.getSupportedHashAlgorithmName(algorithmName, supportedHashAlgorithms);
            if (tempName != null && algorithmName != null && !tempName.equals(algorithmName)) {
                Log.warn("Hash algorithm {} not supported, using algorithm {}", (Object)algorithmName, (Object)tempName);
            }
            return de.intarsys.tools.digest.DigestTools.createDigester((String)tempName);
        }
        catch (ConversionException | NoSuchAlgorithmException e) {
            Log.warn("fall back to SHA1 ({})", (Object)e.getLocalizedMessage(), (Object)e);
            return DigestTools.getDigester("SHA-1");
        }
    }

    public static DigestAlgorithm getHashAlgorithm(IArgs args, String defaultValue) {
        Object value = args.get("digester");
        if (value == null) {
            value = defaultValue;
        }
        return DigestTools.getHashAlgorithm(value);
    }

    public static DigestAlgorithm getHashAlgorithm(Object value) {
        if (value instanceof IDigester) {
            return DigestAlgorithm.lookupAlgorithmCanonical(((IDigester)value).getAlgorithmName());
        }
        if (value instanceof DigestAlgorithm) {
            return ((DigestAlgorithm)value).getCanonical();
        }
        try {
            String algorithmName = (String)ConverterRegistry.get().convert(value, String.class);
            return DigestAlgorithm.lookupAlgorithmCanonical(algorithmName);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getHashAlgorithmName(IArgs args, String defaultValue) {
        Object value = args.get("digester");
        if (value == null) {
            value = defaultValue;
        }
        return DigestTools.getHashAlgorithmName(value);
    }

    public static String getHashAlgorithmName(Object value) {
        if (value instanceof IDigester) {
            return DigestAlgorithm.lookupAlgorithmName(((IDigester)value).getAlgorithmName());
        }
        if (value instanceof DigestAlgorithm) {
            return ((DigestAlgorithm)value).getCanonicalName();
        }
        try {
            String algorithmName = (String)ConverterRegistry.get().convert(value, String.class);
            return DigestAlgorithm.lookupAlgorithmName(algorithmName);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getMostSecureHashAlgorithmName(Collection<String> algorithmNames) {
        DigestAlgorithm result = DigestAlgorithm.ALG_SHA1;
        for (String name : algorithmNames) {
            DigestAlgorithm tmp = DigestAlgorithm.lookupAlgorithmCanonical(name);
            if (tmp.getStrength() <= result.getStrength()) continue;
            result = tmp;
        }
        return result.getName();
    }

    public static String getMostSecureHashAlgorithmOID(Collection<String> digestOIDs) {
        DigestAlgorithm result = DigestAlgorithm.ALG_SHA1;
        for (String name : digestOIDs) {
            DigestAlgorithm tmp = DigestAlgorithm.lookupAlgorithmCanonical(name);
            if (tmp.getStrength() <= result.getStrength()) continue;
            result = tmp;
        }
        return result.getOid();
    }

    public static String getSupportedHashAlgorithmName(String algorithmName, Collection<String> supportedDigestAlgorithms) {
        if (supportedDigestAlgorithms == null || supportedDigestAlgorithms.isEmpty() || StringTools.isEmpty((String)algorithmName)) {
            return "SHA-256";
        }
        if (!DigestAlgorithm.contains(supportedDigestAlgorithms, algorithmName)) {
            algorithmName = DigestTools.getMostSecureHashAlgorithmName(supportedDigestAlgorithms);
        }
        return algorithmName;
    }
}

