/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.encoding;

import de.intarsys.security.encoding.AbstractEncoding;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;

public class Dinsig9796Encoding
extends AbstractEncoding {
    public static final String NAME = "Dinsig9796";

    @Override
    protected byte[] basicDecode(byte[] bytes) throws IOException {
        int index;
        if (bytes.length < 11) {
            throw new IOException("invalid length");
        }
        if ((bytes[0] & 0xFF) != 96) {
            throw new IOException("invalid leading");
        }
        if ((bytes[bytes.length - 1] & 0xFF) != 188) {
            throw new IOException("invalid trailer");
        }
        for (index = 1; index < bytes.length && bytes[index] == 0; ++index) {
        }
        if (index == bytes.length || bytes[index] != 1) {
            throw new IOException("invalid padding");
        }
        if ((index += 9) >= bytes.length) {
            throw new IOException("invalid format");
        }
        int length = bytes.length - index - 1;
        byte[] tempBytes = new byte[length];
        System.arraycopy(bytes, index, tempBytes, 0, length);
        return tempBytes;
    }

    @Override
    protected byte[] basicEncode(byte[] bytes) throws IOException {
        byte[] encoded = new byte[this.getIntendedLengthBytes()];
        if (encoded.length < bytes.length + 11) {
            throw new IOException("message to long (" + bytes.length + ")");
        }
        encoded[0] = 96;
        int stop = encoded.length - bytes.length - 10;
        for (int i = 1; i < stop; ++i) {
            encoded[i] = 0;
        }
        encoded[stop] = 1;
        SecureRandom random = CryptoTools.createSecureRandom();
        byte[] seed = new byte[8];
        random.nextBytes(seed);
        System.arraycopy(seed, 0, encoded, stop + 1, seed.length);
        System.arraycopy(bytes, 0, encoded, stop + 9, bytes.length);
        encoded[encoded.length - 1] = -68;
        return encoded;
    }

    @Override
    protected boolean basicMatch(byte[] bytes, byte[] encoded) throws IOException {
        byte[] unpadded = this.decode(encoded);
        if (bytes.length == unpadded.length) {
            return Arrays.equals(bytes, unpadded);
        }
        try {
            IDigest digest = DigestTools.decode((byte[])bytes);
            byte[] rawBytes = digest.getBytes();
            if (rawBytes.length == unpadded.length) {
                return Arrays.equals(rawBytes, unpadded);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

