/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.encoding;

import de.intarsys.security.encoding.IEncoding;
import de.intarsys.tools.hex.HexTools;
import java.io.IOException;

public class EncodedMessage {
    private final IEncoding encoding;
    private byte[] decoded;
    private byte[] encoded;

    public EncodedMessage(IEncoding encoding) {
        this.encoding = encoding;
    }

    public byte[] getDecoded() throws IOException {
        if (this.decoded == null) {
            this.decoded = this.encoding.decode(this.encoded);
        }
        return this.decoded;
    }

    public byte[] getEncodedBytes() throws IOException {
        if (this.encoded == null) {
            this.encoded = this.encoding.encode(this.decoded);
        }
        return this.encoded;
    }

    public void setDecoded(byte[] bytes) {
        this.decoded = bytes;
        this.encoded = null;
    }

    public void setEncoded(byte[] bytes) {
        this.decoded = null;
        this.encoded = bytes;
    }

    public String toString() {
        try {
            return HexTools.bytesToHexString((byte[])this.getDecoded());
        }
        catch (IOException e) {
            return "<error>";
        }
    }
}

